/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.syntax;

import fr.cnav.saturne.UsageType;
import fr.cnav.saturne.api.model.access.BlockDescription;
import fr.cnav.saturne.api.model.access.DeclarationDescription;
import fr.cnav.saturne.api.model.access.FieldDescription;
import fr.cnav.saturne.api.model.access.MessageElementDescription;
import fr.cnav.saturne.validator.ControlMessages;
import fr.cnav.saturne.validator.SequentialLocalizer;
import fr.cnav.saturne.validator.engine.IRule;
import fr.cnav.saturne.validator.engine.IRuleResult;
import fr.cnav.saturne.validator.engine.RuleFailure;
import fr.cnav.saturne.validator.message.MessageElementFactory;
import fr.cnav.saturne.validator.message.MessageField;
import fr.cnav.saturne.validator.message.api.IMessageBlock;
import fr.cnav.saturne.validator.syntax.AbstractBlockSyntaxControl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Cst03SyntaxControl
extends AbstractBlockSyntaxControl {
    private final String fullQualifiedId;
    private final UsageType usageType;
    private final FieldDescription targetField;
    private MessageElementFactory messageElementFactory;

    public Cst03SyntaxControl(int id, String code, BlockDescription target, FieldDescription targetField, ControlMessages controlMessage, DeclarationDescription declaration, MessageElementFactory messageElementFactory) {
        super(id, code, target, controlMessage, declaration);
        this.messageElementFactory = messageElementFactory;
        this.fullQualifiedId = targetField.getFullQualifiedId();
        this.usageType = declaration == null ? targetField.getUsage() : declaration.getUsage((MessageElementDescription)targetField);
        this.targetField = targetField;
    }

    @Override
    public List<FieldDescription> getUsedData() {
        if (this.getTarget() instanceof FieldDescription) {
            return Stream.of((FieldDescription)this.getTarget()).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        }
        return new ArrayList<FieldDescription>();
    }

    @Override
    public BlockDescription getDeepestAncestor() {
        if (this.getTarget() instanceof BlockDescription && this.getTarget().getParent() instanceof BlockDescription) {
            return (BlockDescription)this.getTarget().getParent();
        }
        return null;
    }

    @Override
    public IRuleResult run(IMessageBlock context) {
        int indexTarget;
        if (this.usageType == UsageType.MANDATORY && context.getStandardBlockDescription() instanceof BlockDescription && context.getField(indexTarget = ((BlockDescription)context.getStandardBlockDescription()).getFields().indexOf(this.targetField)) == null) {
            SequentialLocalizer fieldLocalizer = new SequentialLocalizer(context.getFirstLine());
            MessageField<?> triggerField = this.messageElementFactory.createMessageField(this.fullQualifiedId, null, fieldLocalizer);
            String message = this.controlMessage.getMessage("syntactic.messages.CST03", new Object[]{this.fullQualifiedId});
            RuleFailure result = new RuleFailure(this, triggerField, context, message);
            return result;
        }
        return IRule.SUCCESS;
    }
}

