/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.syntax;

import fr.cnav.saturne.api.model.access.BlockDescription;
import fr.cnav.saturne.api.model.access.DeclarationDescription;
import fr.cnav.saturne.api.model.access.FieldDescription;
import fr.cnav.saturne.api.model.access.HeaderBlockDescription;
import fr.cnav.saturne.api.model.access.MessageDescription;
import fr.cnav.saturne.api.model.access.MessageElementDescription;
import fr.cnav.saturne.validator.ControlMessages;
import fr.cnav.saturne.validator.engine.IRule;
import fr.cnav.saturne.validator.engine.IRuleResult;
import fr.cnav.saturne.validator.engine.RuleFailure;
import fr.cnav.saturne.validator.message.api.IMessageBlock;
import fr.cnav.saturne.validator.message.api.IMessageField;
import fr.cnav.saturne.validator.syntax.AbstractBlockSyntaxControl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Cst02SyntaxControl
extends AbstractBlockSyntaxControl {
    private final BlockDescription block;
    private List<FieldDescription> usedData;

    public Cst02SyntaxControl(int id, String code, BlockDescription target, ControlMessages controlMessage, DeclarationDescription declaration) {
        super(id, code, target, controlMessage, declaration);
        if (code == null || target == null) {
            throw new IllegalArgumentException(String.valueOf(this.getClass().getSimpleName()) + " : The constructor parameters can't be null");
        }
        this.block = target;
        this.initUsedData();
    }

    private void initUsedData() {
        this.usedData = new ArrayList<FieldDescription>();
        if (this.getTarget() instanceof BlockDescription) {
            this.usedData.addAll(((BlockDescription)this.getTarget()).getFields());
        }
    }

    @Override
    public List<FieldDescription> getUsedData() {
        return this.usedData;
    }

    private List<IMessageBlock> occurencesInContext(IMessageBlock context) {
        List<IMessageBlock> messageBlocks = null;
        if (context.getStandardBlockDescription() instanceof BlockDescription) {
            int idxOftargetBlock = ((BlockDescription)context.getStandardBlockDescription()).getChildrenBlocks().indexOf(this.block);
            messageBlocks = context.getBlock(idxOftargetBlock);
        } else if (context.getStandardBlockDescription() instanceof MessageDescription) {
            messageBlocks = this.block instanceof HeaderBlockDescription ? context.getBlock(0) : context.getBlock(1);
        }
        return messageBlocks;
    }

    private int getLowerBound(BlockDescription aBlock) {
        if (this.declaration != null) {
            return this.declaration.getBlockLowerBound(aBlock);
        }
        return aBlock.getLowerBound();
    }

    private int getUpperBound(BlockDescription aBlock) {
        if (this.declaration != null) {
            return this.declaration.getBlockUpperBound(aBlock);
        }
        return aBlock.getUpperBound();
    }

    private boolean isForbidden(BlockDescription aBlock) {
        if (this.declaration != null) {
            return this.declaration.getBlockLowerBound(aBlock) == 0 && this.declaration.getBlockUpperBound(aBlock) == 0;
        }
        return aBlock.getLowerBound() == 0 && aBlock.getUpperBound() == 0;
    }

    private boolean isMandatory(BlockDescription aBlock) {
        if (this.declaration != null) {
            return this.declaration.getBlockLowerBound(aBlock) == 1;
        }
        return aBlock.getLowerBound() == 1;
    }

    @Override
    public IRuleResult run(IMessageBlock context) {
        List<IMessageBlock> occurences = this.occurencesInContext(context);
        IRuleResult result = IRule.SUCCESS;
        String firstRubriqueInDeclarationValue = "";
        String previousSubGroupQualifiedId = null;
        String subGroupFullQualifiedId = this.block.getFullQualifiedId();
        int expectedUpperBound = this.getUpperBound(this.block);
        int expectedLowerBound = this.getLowerBound(this.block);
        int occurencesNb = occurences.size();
        String message = null;
        if (this.isMandatory(this.block) && occurencesNb == 0) {
            IMessageField<?> firstRubrique = this.getFirstFieldInSubBlock(context);
            previousSubGroupQualifiedId = this.calculatePreviousSubGroup(context);
            message = previousSubGroupQualifiedId == null ? this.controlMessage.getMessage("syntactic.messages.CST02_1_2", new Object[]{subGroupFullQualifiedId}) : this.controlMessage.getMessage("syntactic.messages.CST02_1", new Object[]{subGroupFullQualifiedId, previousSubGroupQualifiedId});
            result = new RuleFailure(this, firstRubrique, context, message);
        } else if (this.isForbidden(this.block) && occurencesNb > 0) {
            IMessageBlock firstOccurence = occurences.get(0);
            IMessageField<?> firstRubrique = this.getFirstFieldInSubBlock(firstOccurence);
            if (this.declaration != null) {
                firstRubriqueInDeclarationValue = this.declaration.getName();
            }
            message = this.controlMessage.getMessage("syntactic.messages.CST02_2", new Object[]{subGroupFullQualifiedId, firstRubriqueInDeclarationValue});
            result = new RuleFailure(this, firstRubrique, context, message);
        } else if (expectedUpperBound > 0 && occurencesNb > expectedUpperBound) {
            IMessageField<?> firstRubrique = this.getFirstFieldInSubBlock(occurences.get(expectedUpperBound));
            message = this.controlMessage.getMessage("syntactic.messages.CST02_3", new Object[]{subGroupFullQualifiedId});
            result = new RuleFailure(this, firstRubrique, context, message);
        } else if (occurencesNb < expectedLowerBound) {
            IMessageField<?> firstRubrique = this.getFirstFieldInSubBlock(context);
            message = this.controlMessage.getMessage("syntactic.messages.CST02_3", new Object[]{subGroupFullQualifiedId});
            result = new RuleFailure(this, firstRubrique, context, message);
        }
        return result;
    }

    private String calculatePreviousSubGroup(IMessageBlock context) {
        BlockDescription previousBlock;
        List<IMessageBlock> contextSubGroups = this.getChildrenMsgBlockList(context);
        Object previousSubGroupQualifiedId = "";
        previousSubGroupQualifiedId = this.block instanceof HeaderBlockDescription ? null : (contextSubGroups.size() == 0 ? (this.block.getParent() instanceof MessageDescription ? null : ((BlockDescription)this.block.getParent()).getFullQualifiedId()) : (this.block.getParent() instanceof MessageDescription && this.isTargetFirstSubGroup(this.block) ? null : (this.isTargetFirstSubGroup(this.block) ? this.block.getFullQualifiedId() : (this.block.getParent() != null && this.block.getParent() instanceof BlockDescription ? ((previousBlock = this.getPreviousBlockAmongSiblings(contextSubGroups)) != null ? previousBlock.getFullQualifiedId() : ((BlockDescription)this.block.getParent()).getFullQualifiedId()) : (this.block.getParent() != null && this.block.getParent() instanceof MessageDescription ? ((previousBlock = this.getPreviousBlockAmongSiblings(contextSubGroups)) != null ? previousBlock.getFullQualifiedId() : ((MessageDescription)this.block.getParent()).getFullQualifiedId()) : this.block.getFullQualifiedId())))));
        return previousSubGroupQualifiedId;
    }

    private BlockDescription getPreviousBlockAmongSiblings(List<IMessageBlock> contextBlocks) {
        IMessageBlock previousBlock = null;
        if (this.block.getParent() instanceof MessageDescription) {
            previousBlock = contextBlocks.get(0);
        } else {
            List childrenOrderedBlocks = ((BlockDescription)this.block.getParent()).getChildrenBlocks();
            BlockDescription targetBlock = (BlockDescription)this.getTarget();
            int indexReferenceChild = childrenOrderedBlocks.indexOf(targetBlock);
            int indexLastSibling = -1;
            int size = contextBlocks.size();
            int i = 0;
            while (i < size) {
                IMessageBlock messageBlock = contextBlocks.get(i);
                int indexSibling = childrenOrderedBlocks.indexOf(messageBlock.getStandardBlockDescription());
                if (indexSibling < indexReferenceChild && indexSibling > indexLastSibling) {
                    previousBlock = messageBlock;
                    indexLastSibling = indexSibling;
                }
                ++i;
            }
        }
        if (previousBlock != null) {
            return this.getLastSubBlock(previousBlock);
        }
        return null;
    }

    private BlockDescription getLastSubBlock(IMessageBlock messageBlock) {
        List<IMessageBlock> childrenMesssageBlock = this.getChildrenMsgBlockList(messageBlock);
        if (childrenMesssageBlock.size() == 0) {
            return (BlockDescription)messageBlock.getStandardBlockDescription();
        }
        IMessageBlock lastMessageBlock = this.getLastBlockOfList(childrenMesssageBlock, (BlockDescription)messageBlock.getStandardBlockDescription());
        return this.getLastSubBlock(lastMessageBlock);
    }

    private IMessageBlock getLastBlockOfList(List<IMessageBlock> childrenMesssageBlock, BlockDescription previousStandardBlock) {
        List childrenBlocks = previousStandardBlock.getChildrenBlocks();
        int indexLastBlock = -1;
        IMessageBlock lastMessageBlock = null;
        int size = childrenMesssageBlock.size();
        int i = 0;
        while (i < size) {
            IMessageBlock messageBlock = childrenMesssageBlock.get(i);
            int indexCurrentMessageBlock = childrenBlocks.indexOf(messageBlock.getStandardBlockDescription());
            if (indexCurrentMessageBlock > indexLastBlock) {
                lastMessageBlock = messageBlock;
                indexLastBlock = indexCurrentMessageBlock;
            }
            ++i;
        }
        return lastMessageBlock;
    }

    private boolean isTargetFirstSubGroup(BlockDescription parent) {
        return !parent.getChildrenBlocks().isEmpty() && this.block.getFullQualifiedId().equals(((BlockDescription)parent.getChildrenBlocks().get(0)).getFullQualifiedId());
    }

    private List<IMessageBlock> getChildrenMsgBlockList(IMessageBlock messageBlock) {
        ArrayList<IMessageBlock> contextSubGroups = new ArrayList<IMessageBlock>();
        MessageElementDescription standardBlock = messageBlock.getStandardBlockDescription();
        if (standardBlock instanceof BlockDescription) {
            int numberOfBlock = ((BlockDescription)standardBlock).getChildrenBlocks().size();
            int i = 0;
            while (i < numberOfBlock) {
                contextSubGroups.addAll(messageBlock.getBlock(i));
                ++i;
            }
        } else if (standardBlock instanceof MessageDescription) {
            contextSubGroups.addAll(messageBlock.getBlock(0));
            contextSubGroups.addAll(messageBlock.getBlock(1));
        }
        return contextSubGroups;
    }

    private IMessageField<?> getFirstFieldInSubBlock(IMessageBlock context) {
        IMessageField<?> result = null;
        if (context.getStandardBlockDescription() instanceof BlockDescription && (result = this.getFirstFieldInBlock(context)) == null) {
            int numberOfBlock = ((BlockDescription)context.getStandardBlockDescription()).getChildrenBlocks().size();
            int i = 0;
            while (i < numberOfBlock) {
                for (IMessageBlock msgBlock : context.getBlock(i)) {
                    result = this.getFirstFieldInSubBlock(msgBlock);
                    if (result == null) continue;
                    return result;
                }
                ++i;
            }
        }
        return result;
    }

    private IMessageField<?> getFirstFieldInBlock(IMessageBlock msgBlock) {
        Iterator<IMessageField<?>> iterator = msgBlock.getFields().iterator();
        if (iterator.hasNext()) {
            IMessageField<?> msgField = iterator.next();
            return msgField;
        }
        return null;
    }
}

