/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.report.impl;

import fr.cnav.saturne.api.model.access.StandardAccessor;
import fr.cnav.saturne.report.model.Context;
import fr.cnav.saturne.validator.report.IReportLogger;
import fr.cnav.saturne.validator.report.IReportSerializer;
import fr.cnav.saturne.validator.report.SerializationException;
import fr.cnav.saturne.validator.report.impl.AbstractReportSerializerHandler;
import fr.cnav.saturne.validator.report.impl.GenericCSVReportSerializerHandler;
import java.io.OutputStream;
import java.io.Writer;
import java.util.List;

public class GenericCSVReportSerializer
implements IReportSerializer {
    @Override
    public void serialize(OutputStream outputStream, IReportLogger reportLogger, String namespacePrefix, String namespace, StandardAccessor modelAccessor) throws SerializationException {
        AbstractReportSerializerHandler csvHandler = this.buildHandler(outputStream, reportLogger);
        csvHandler.beginSerialization();
        this.serialize(reportLogger.getReport().getRootContext(), csvHandler);
        csvHandler.endSerialization();
    }

    public void serialize(Writer writer, IReportLogger reportLogger) throws SerializationException {
        AbstractReportSerializerHandler csvHandler = this.buildHandler(writer, reportLogger);
        csvHandler.beginSerialization();
        this.serialize(reportLogger.getReport().getRootContext(), csvHandler);
        csvHandler.endSerialization();
    }

    private void serialize(Context context, AbstractReportSerializerHandler csvHandler) throws SerializationException {
        csvHandler.pushContext(context);
        List<Context> contextChildren = context.getContextChildren();
        for (Context contextChild : contextChildren) {
            this.serialize(contextChild, csvHandler);
        }
        csvHandler.popContext();
    }

    protected AbstractReportSerializerHandler buildHandler(OutputStream outputStream, IReportLogger reportLogger) throws SerializationException {
        return new GenericCSVReportSerializerHandler(reportLogger, outputStream, null);
    }

    protected AbstractReportSerializerHandler buildHandler(Writer writer, IReportLogger reportLogger) throws SerializationException {
        return new GenericCSVReportSerializerHandler(reportLogger, writer);
    }
}

