/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.positional.csv.importer;

import com.opencsv.CSVReader;
import fr.cnav.saturne.validator.positional.csv.DefaultCSVParameters;
import fr.cnav.saturne.validator.positional.csv.ICSVParameters;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IPath;

public class ImportCSVReader {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final String MESSAGE_SEPARATOR = " , ";
    private static final String ERROR_MESSAGE_FILE_INVALID_FORMAT = "This file does not match the expected columns: ";

    public InputStreamReader getInputReader(IPath path, String encoding) throws FileNotFoundException {
        if (path == null) {
            throw new IllegalArgumentException("The CSV file path cannot be null.");
        }
        File file = path.toFile();
        try {
            if (encoding == null) {
                return new InputStreamReader((InputStream)new FileInputStream(file), DEFAULT_ENCODING);
            }
            return new InputStreamReader((InputStream)new FileInputStream(file), encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean validateColumns(String[] expectedColumns, String[] columns, StringBuilder message) {
        if (expectedColumns == null) {
            throw new IllegalArgumentException("The expected columns cannot be null.");
        }
        if (columns == null) {
            throw new IllegalArgumentException("The CSV file must contain columns with titles.");
        }
        if (message == null) {
            throw new IllegalArgumentException("The String builder cannot be null.");
        }
        if (this.match(expectedColumns, columns)) {
            return true;
        }
        message.append(ERROR_MESSAGE_FILE_INVALID_FORMAT);
        Iterator<String> iterator = Arrays.asList(expectedColumns).iterator();
        while (iterator.hasNext()) {
            String column = iterator.next();
            message.append(column);
            if (!iterator.hasNext()) continue;
            message.append(MESSAGE_SEPARATOR);
        }
        return false;
    }

    private boolean match(String[] expectedColumns, String[] columns) {
        return columns.length >= expectedColumns.length;
    }

    public List<String[]> getList(File file, ICSVParameters theParameters, String encoding) throws IOException {
        List lines;
        this.checkFileAttribute(file);
        ICSVParameters parameters = this.checkParameterAttribute(theParameters);
        String currentEncoding = this.checkEncoding(parameters, encoding);
        InputStreamReader isReader = null;
        try {
            isReader = new InputStreamReader((InputStream)new FileInputStream(file), currentEncoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new UnsupportedOperationException("Does not support encoding '" + currentEncoding + "'");
        }
        try (CSVReader reader = null;){
            reader = new CSVReader((Reader)isReader, parameters.getColumnSeparator().charAt(0), parameters.getColumnDelimiter().charAt(0), parameters.hasTitleLine() ? 1 : 0);
            lines = reader.readAll();
        }
        return lines;
    }

    private String checkEncoding(ICSVParameters parameters, String encoding) {
        String currentEncoding = parameters.getEncoding();
        if (encoding != null) {
            currentEncoding = encoding;
        }
        return currentEncoding;
    }

    private ICSVParameters checkParameterAttribute(ICSVParameters theParameters) {
        String columnSeparator;
        ICSVParameters parameters = theParameters;
        if (parameters == null) {
            parameters = new DefaultCSVParameters();
        }
        if ((columnSeparator = parameters.getColumnSeparator()) == null || columnSeparator.isEmpty()) {
            throw new UnsupportedOperationException("The column separator cannot be undefined or empty.");
        }
        String columnDelimiter = parameters.getColumnDelimiter();
        if (columnDelimiter == null || columnDelimiter.isEmpty()) {
            throw new UnsupportedOperationException("The column delimiter cannot be undefined or empty.");
        }
        return parameters;
    }

    private void checkFileAttribute(File file) {
        if (file == null) {
            throw new IllegalArgumentException("The file must not be null.");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("The file is not found.");
        }
    }
}

