/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.functions;

import fr.cnav.saturne.api.model.access.StandardAccessor;
import fr.cnav.saturne.api.model.access.StandardDescription;
import fr.cnav.saturne.validator.ITreeConsumer;
import fr.cnav.saturne.validator.TreeProcessingException;
import fr.cnav.saturne.validator.api.AbstractKBDescriptor;
import fr.cnav.saturne.validator.conversion.ConversionSerializationException;
import fr.cnav.saturne.validator.conversion.OriginalValueOptionValue;
import fr.cnav.saturne.validator.conversion.csv.CSVSerializer;
import fr.cnav.saturne.validator.conversion.json.JsonStreamSerializer;
import fr.cnav.saturne.validator.conversion.keyvalue.SequentialSerializer;
import fr.cnav.saturne.validator.conversion.xml.XMLSerializer;
import fr.cnav.saturne.validator.functions.ValidationFunctionException;
import fr.cnav.saturne.validator.message.MessageProvider;
import fr.cnav.saturne.validator.message.api.IMessageBlock;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelperSerialisation {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final OriginalValueOptionValue emitOriginalValue;
    private final boolean emitOriginalLineNumber;
    private final AbstractKBDescriptor abstractKBDescriptor;

    public HelperSerialisation(AbstractKBDescriptor abstractKBDescriptor, OriginalValueOptionValue emitOriginalValue, boolean emitOriginalLineNumber) throws ValidationFunctionException {
        this.abstractKBDescriptor = abstractKBDescriptor;
        this.emitOriginalValue = emitOriginalValue;
        this.emitOriginalLineNumber = emitOriginalLineNumber;
    }

    public void serializeToXML(IMessageBlock message, OutputStream xmlOutput, String encoding) throws IOException, ValidationFunctionException {
        this.logger.info("[Saturne] Start of the serialization of the converted message");
        if (message == null) {
            throw new IllegalArgumentException("The parameter outputStream cannot be null");
        }
        if (xmlOutput == null) {
            throw new IllegalArgumentException("The parameter message of the conversion method can't be null");
        }
        if (encoding == null) {
            throw new IllegalArgumentException("The parameter encoding of the serializeXML method can't be null");
        }
        try {
            MessageProvider messageProvider = new MessageProvider(this.getModelAccessor());
            XMLSerializer xmlSerializer = new XMLSerializer(this.getStandardDescription(), xmlOutput, encoding, this.emitOriginalValue, this.emitOriginalLineNumber);
            messageProvider.addConsumer(xmlSerializer);
            messageProvider.notifiesMessage(message);
        }
        catch (ConversionSerializationException e) {
            this.logger.error("[Saturne] The serialization of the converted message has failed", (Throwable)e);
            throw new ValidationFunctionException(e);
        }
        catch (TreeProcessingException e) {
            this.logger.error("[Saturne] The serialization of the converted message has failed", (Throwable)e);
            throw new ValidationFunctionException(e);
        }
        this.logger.info("[Saturne] End of the serialization of the converted message");
    }

    public void serializeToXML(IMessageBlock messageBlock, ITreeConsumer serializer) throws IOException, ValidationFunctionException {
        this.logger.info("[Saturne] Start of the serialization of the converted message");
        if (messageBlock == null) {
            throw new IllegalArgumentException("The parameter messageBlock of the conversion method can't be null");
        }
        if (serializer == null) {
            throw new IllegalArgumentException("The parameter xmlSerializer of the serializeXML method can't be null");
        }
        try {
            MessageProvider messageProvider = new MessageProvider(this.getModelAccessor());
            messageProvider.addConsumer(serializer);
            messageProvider.notifiesMessage(messageBlock);
        }
        catch (TreeProcessingException e) {
            this.logger.error("[Saturne] The serialization of the converted message has failed", (Throwable)e);
            throw new ValidationFunctionException(e);
        }
        this.logger.info("[Saturne] End of the serialization of the converted message");
    }

    public void serializeToCSV(IMessageBlock messageBlock, ITreeConsumer serializer) throws IOException, ValidationFunctionException {
        this.logger.info("[Saturne] Start of the serialization of the converted message");
        if (messageBlock == null) {
            throw new IllegalArgumentException("The parameter messageBlock of the conversion method can't be null");
        }
        if (serializer == null) {
            throw new IllegalArgumentException("The parameter xmlSerializer of the serializeXML method can't be null");
        }
        try {
            MessageProvider messageProvider = new MessageProvider(this.getModelAccessor());
            messageProvider.addConsumer(serializer);
            messageProvider.notifiesMessage(messageBlock);
        }
        catch (TreeProcessingException e) {
            this.logger.error("[Saturne] The serialization of the converted message has failed", (Throwable)e);
            throw new ValidationFunctionException(e);
        }
        this.logger.info("[Saturne] End of the serialization of the converted message");
    }

    public void serializeToCSV(IMessageBlock message, OutputStream csvOutput, String encoding) throws IOException, ValidationFunctionException {
        this.logger.info("[Saturne] Start of the serialization of the converted message");
        if (message == null) {
            throw new IllegalArgumentException("The parameter outputStream cannot be null");
        }
        if (csvOutput == null) {
            throw new IllegalArgumentException("The parameter message of the conversion method can't be null");
        }
        try {
            MessageProvider messageProvider = new MessageProvider(this.getModelAccessor());
            CSVSerializer csvSerializer = new CSVSerializer(this.getModelAccessor().getStandard(), csvOutput, encoding, '\"', ';');
            messageProvider.addConsumer(csvSerializer);
            messageProvider.notifiesMessage(message);
        }
        catch (ConversionSerializationException e) {
            this.logger.error("[Saturne] The serialization of the converted message has failed", (Throwable)e);
            throw new ValidationFunctionException(e);
        }
        catch (TreeProcessingException e) {
            this.logger.error("[Saturne] The serialization of the converted message has failed", (Throwable)e);
            throw new ValidationFunctionException(e);
        }
        this.logger.info("[Saturne] End of the serialization of the converted message");
    }

    public void serializeToJson(IMessageBlock message, OutputStream jsonOutput, String encoding) throws IOException, ValidationFunctionException {
        this.logger.info("[Saturne] Start of the serialization of the converted message");
        if (message == null) {
            throw new IllegalArgumentException("The parameter outputStream cannot be null");
        }
        if (jsonOutput == null) {
            throw new IllegalArgumentException("The parameter message of the conversion method can't be null");
        }
        try {
            MessageProvider messageProvider = new MessageProvider(this.getModelAccessor());
            JsonStreamSerializer jsonSerializer = new JsonStreamSerializer(this.getModelAccessor().getStandardDescription(), jsonOutput, Charset.forName(encoding));
            messageProvider.addConsumer(jsonSerializer);
            messageProvider.notifiesMessage(message);
        }
        catch (TreeProcessingException e) {
            this.logger.error("[Saturne] The serialization of the converted message has failed", (Throwable)e);
            throw new ValidationFunctionException(e);
        }
        this.logger.info("[Saturne] End of the serialization of the converted message");
    }

    public void serializeToKeyValue(IMessageBlock message, OutputStream output) throws IOException, ValidationFunctionException {
        this.logger.info("[Saturne] Start of the serialization of the converted message");
        if (message == null) {
            throw new IllegalArgumentException("The parameter outputStream cannot be null");
        }
        if (output == null) {
            throw new IllegalArgumentException("The parameter message of the conversion method can't be null");
        }
        try {
            MessageProvider messageProvider = new MessageProvider(this.getModelAccessor());
            SequentialSerializer keyValueSerializer = new SequentialSerializer(this.getModelAccessor().getStandard(), output);
            messageProvider.addConsumer(keyValueSerializer);
            messageProvider.notifiesMessage(message);
        }
        catch (ConversionSerializationException e) {
            this.logger.error("[Saturne] The serialization of the converted message has failed", (Throwable)e);
            throw new ValidationFunctionException(e);
        }
        catch (TreeProcessingException e) {
            this.logger.error("[Saturne] The serialization of the converted message has failed", (Throwable)e);
            throw new ValidationFunctionException(e);
        }
        this.logger.info("[Saturne] End of the serialization of the converted message");
    }

    public void serializeToKeyValue(IMessageBlock message, ITreeConsumer serializer) throws IOException, ValidationFunctionException {
        this.logger.info("[Saturne] Start of the serialization of the converted message");
        if (message == null) {
            throw new IllegalArgumentException("The parameter outputStream cannot be null");
        }
        if (serializer == null) {
            throw new IllegalArgumentException("The parameter xmlSerializer of the serializeXML method can't be null");
        }
        try {
            MessageProvider messageProvider = new MessageProvider(this.getModelAccessor());
            messageProvider.addConsumer(serializer);
            messageProvider.notifiesMessage(message);
        }
        catch (TreeProcessingException e) {
            this.logger.error("[Saturne] The serialization of the converted message has failed", (Throwable)e);
            throw new ValidationFunctionException(e);
        }
        this.logger.info("[Saturne] End of the serialization of the converted message");
    }

    private StandardDescription getStandardDescription() {
        return this.getModelAccessor().getStandardDescription();
    }

    private StandardAccessor getModelAccessor() {
        return this.abstractKBDescriptor.getStandardAccessor();
    }
}

