/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.conversion.xml;

import fr.cnav.saturne.validator.conversion.xml.XMLFormattingException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class XMLFormattingWriter
extends Writer {
    public static final String DEFAULT_INDENTATION = "    ";
    public static final String DEFAULT_EOL = "\n";
    private final String encoding;
    private final String indentation;
    private final String endOfLine;
    private final String version;
    private final boolean formatting;
    private final XMLStreamWriter writer;
    private int indentationLevel;

    public XMLFormattingWriter(OutputStream output, String encoding, String indentation, String endOfLine, String version, boolean formatting) throws XMLFormattingException {
        this.encoding = encoding == null ? "UTF-8" : encoding;
        this.indentation = indentation;
        this.endOfLine = endOfLine;
        this.version = version;
        this.formatting = formatting;
        this.writer = this.buildXMLStreamWriter(output);
    }

    public XMLFormattingWriter(OutputStream output, String encoding, String version) throws XMLFormattingException {
        this(output, encoding, "UTF-8", DEFAULT_EOL, version, false);
    }

    public XMLFormattingWriter(OutputStream output) throws XMLFormattingException {
        this(output, "UTF-8", DEFAULT_INDENTATION, DEFAULT_EOL, "1.0", false);
    }

    public void writeEndOfLine() throws XMLFormattingException {
        try {
            if (this.formatting) {
                this.writer.writeCharacters(this.endOfLine);
            }
        }
        catch (XMLStreamException e) {
            throw new XMLFormattingException(e);
        }
    }

    private void writeIndentation() throws XMLStreamException {
        if (this.formatting) {
            StringBuilder builder = new StringBuilder();
            int i = 0;
            while (i < this.indentationLevel) {
                builder.append(this.indentation);
                ++i;
            }
            this.writer.writeCharacters(builder.toString());
        }
    }

    public void writeNamespace(String prefix, String namespaceURI) throws XMLFormattingException {
        try {
            this.writer.writeNamespace(prefix, namespaceURI);
        }
        catch (XMLStreamException e) {
            throw new XMLFormattingException(e);
        }
    }

    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLFormattingException {
        try {
            this.writer.writeAttribute(namespaceURI, localName, value);
        }
        catch (XMLStreamException e) {
            throw new XMLFormattingException(e);
        }
    }

    public void writeAttribute(String localName, String value) throws XMLFormattingException {
        try {
            this.writer.writeAttribute(localName, value);
        }
        catch (XMLStreamException e) {
            throw new XMLFormattingException(e);
        }
    }

    public void setPrefix(String prefix, String uri) throws XMLFormattingException {
        try {
            this.writer.setPrefix(prefix, uri);
        }
        catch (XMLStreamException e) {
            throw new XMLFormattingException(e);
        }
    }

    public void writeStartDocument() throws XMLFormattingException {
        try {
            this.writer.writeStartDocument(this.encoding, this.version);
        }
        catch (XMLStreamException e) {
            throw new XMLFormattingException(e);
        }
    }

    public void writeStartElement(String namespaceURI, String localName) throws XMLFormattingException {
        try {
            this.writeEndOfLine();
            this.writeIndentation();
            ++this.indentationLevel;
            this.writer.writeStartElement(namespaceURI, localName);
        }
        catch (XMLStreamException e) {
            throw new XMLFormattingException(e);
        }
    }

    public void writeStartElement(String localName) throws XMLFormattingException {
        try {
            this.writeEndOfLine();
            this.writeIndentation();
            ++this.indentationLevel;
            this.writer.writeStartElement(localName);
        }
        catch (XMLStreamException e) {
            throw new XMLFormattingException(e);
        }
    }

    public void writeEmptyElement(String namespaceURI, String localName) throws XMLFormattingException {
        try {
            this.writeEndOfLine();
            this.writeIndentation();
            this.writer.writeEmptyElement(namespaceURI, localName);
        }
        catch (XMLStreamException e) {
            throw new XMLFormattingException(e);
        }
    }

    public void writeEmptyElement(String localName) throws XMLFormattingException {
        try {
            this.writeEndOfLine();
            this.writeIndentation();
            this.writer.writeEmptyElement(localName);
        }
        catch (XMLStreamException e) {
            throw new XMLFormattingException(e);
        }
    }

    public void writeEndElement(boolean newLine, boolean indentBeforeEndElement) throws XMLFormattingException {
        try {
            if (newLine) {
                this.writeEndOfLine();
            }
            --this.indentationLevel;
            if (indentBeforeEndElement) {
                this.writeIndentation();
            }
            this.writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new XMLFormattingException(e);
        }
    }

    public void writeEndDocument() throws XMLFormattingException {
        try {
            this.writeEndOfLine();
            this.writer.writeEndDocument();
        }
        catch (XMLStreamException e) {
            throw new XMLFormattingException(e);
        }
    }

    public void writeCharacters(String text) throws XMLFormattingException {
        try {
            this.writer.writeCharacters(text);
        }
        catch (XMLStreamException e) {
            throw new XMLFormattingException(e);
        }
    }

    public void writeCharacters(boolean newLine, String text) throws XMLFormattingException {
        try {
            if (newLine) {
                this.writeEndOfLine();
                this.writeIndentation();
            }
            this.writer.writeCharacters(text);
        }
        catch (XMLStreamException e) {
            throw new XMLFormattingException(e);
        }
    }

    @Override
    public void flush() throws IOException {
        try {
            this.writer.flush();
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    protected XMLStreamWriter buildXMLStreamWriter(OutputStream output) throws XMLFormattingException {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(output, this.encoding));
            XMLOutputFactory factory = this.getXMLOutputFactory();
            return factory.createXMLStreamWriter(bufferedWriter);
        }
        catch (XMLStreamException exception) {
            throw new XMLFormattingException(exception);
        }
        catch (UnsupportedEncodingException exception) {
            throw new XMLFormattingException("unsupported encoding : " + this.encoding, exception);
        }
    }

    protected XMLOutputFactory getXMLOutputFactory() {
        return XMLOutputFactory.newInstance();
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        try {
            this.writer.writeCharacters(cbuf, off, len);
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.writer.close();
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    public void writeComment(String comment) throws XMLFormattingException {
        try {
            this.writeEndOfLine();
            this.writeIndentation();
            this.writer.writeComment(comment);
        }
        catch (XMLStreamException e) {
            throw new XMLFormattingException(e);
        }
    }
}

