/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.conversion.keyvalue;

import fr.cnav.saturne.api.model.access.DeclarationBlockDescription;
import fr.cnav.saturne.api.model.access.FieldDescription;
import fr.cnav.saturne.api.model.access.StandardAccessor;
import fr.cnav.saturne.api.model.access.StandardDescription;
import fr.cnav.saturne.options.Key;
import fr.cnav.saturne.options.OptionMap;
import fr.cnav.saturne.validator.ControlMessages;
import fr.cnav.saturne.validator.ISequenceProvider;
import fr.cnav.saturne.validator.SaturneValidatorException;
import fr.cnav.saturne.validator.ValidationInformation;
import fr.cnav.saturne.validator.conversion.keyvalue.SequentialLineReader;
import fr.cnav.saturne.validator.message.MessageBlock;
import fr.cnav.saturne.validator.message.MessageElementFactory;
import fr.cnav.saturne.validator.message.MessageField;
import fr.cnav.saturne.validator.message.api.IMessageBlock;
import fr.cnav.saturne.validator.message.api.IMessageField;
import java.io.InputStream;
import java.nio.charset.Charset;

public class SequentialReader
implements ISequenceProvider {
    public static final int FIELD_START_NUMBER = 1;
    private SequentialLineReader reader;
    private StandardAccessor modelAccessor;
    private OptionMap options;
    private IMessageBlock lastBlock;
    private boolean keepFaultyFields;

    public SequentialReader(StandardDescription standard, OptionMap optionsMap, ControlMessages controlMessages, StandardAccessor theModelAcessor, InputStream input, Charset charset) {
        this.reader = new SequentialLineReader(input, charset, optionsMap, controlMessages, theModelAcessor);
        this.options = optionsMap;
        Boolean optionValue = (Boolean)this.options.getOption(new Key("sequence.provider.keep.faulty.fields"));
        if (optionValue != null) {
            this.keepFaultyFields = optionValue;
        }
        this.modelAccessor = theModelAcessor;
    }

    @Override
    public IMessageBlock getNextBlock() throws SaturneValidatorException {
        if (this.lastBlock == null) {
            this.lastBlock = this.readNextBlock();
        }
        return this.lastBlock;
    }

    private boolean isFieldStructurallyInvalid(IMessageField<?> field) {
        return field.getOriginalValueAsString() == null;
    }

    @Override
    public void consummeBlock() {
        this.lastBlock = null;
    }

    private IMessageBlock readNextBlock() throws SaturneValidatorException {
        IMessageField<?> nextField = this.reader.getNextField();
        IMessageBlock block = null;
        ValidationInformation info = new ValidationInformation();
        while (nextField != null && nextField.getIndex() < 0) {
            this.reader.consumme();
            info.getAnomalies().addAll(((ValidationInformation)((MessageField)nextField).getAnnotations().get(0)).getAnomalies());
            nextField = this.reader.getNextField();
        }
        if (nextField != null) {
            block = this.getBlockFromField(nextField.getStandardFieldDescription());
            this.reader.consumme();
            if (!this.isFieldStructurallyInvalid(nextField) || this.keepFaultyFields) {
                block.addField(nextField);
            } else {
                info.getAnomalies().addAll(((ValidationInformation)((MessageField)nextField).getAnnotations().get(0)).getAnomalies());
            }
            IMessageField<?> lastInsertedField = nextField;
            ((MessageBlock)block).addAnnotation(info);
            nextField = this.nextFieldOfBlock(block, lastInsertedField);
            while (nextField != null) {
                if (nextField.getIndex() >= 0 && (!this.isFieldStructurallyInvalid(nextField) || this.keepFaultyFields)) {
                    block.addField(nextField);
                    lastInsertedField = nextField;
                } else {
                    info.getAnomalies().addAll(((ValidationInformation)((MessageField)nextField).getAnnotations().get(0)).getAnomalies());
                }
                this.reader.consumme();
                nextField = this.nextFieldOfBlock(block, lastInsertedField);
            }
            return block;
        }
        return null;
    }

    private IMessageField<?> nextFieldOfBlock(IMessageBlock block, IMessageField<?> lastInsertedField) throws SaturneValidatorException {
        FieldDescription field;
        IMessageField<?> nextField = this.reader.getNextField();
        IMessageField<Object> result = nextField != null ? ((field = nextField.getStandardFieldDescription()) == null || nextField.getIndex() < 0 || field.getParent().equals(lastInsertedField.getStandardFieldDescription().getParent()) && nextField.getIndex() > lastInsertedField.getIndex() ? nextField : null) : null;
        return result;
    }

    private IMessageBlock getBlockFromField(FieldDescription field) {
        MessageBlock nextMessageBlock = null;
        MessageElementFactory messageElementFactory = new MessageElementFactory(this.modelAccessor);
        if (field.getParent() instanceof DeclarationBlockDescription) {
            nextMessageBlock = messageElementFactory.createDeclarationBlock(field.getParent().getFullQualifiedId(), null);
        } else {
            nextMessageBlock = messageElementFactory.createMessageBlock(field.getParent().getFullQualifiedId());
            nextMessageBlock.setFirstLine(this.reader.getCurrentLineNumber());
        }
        return nextMessageBlock;
    }

    @Override
    public OptionMap getOptions() {
        return this.options;
    }
}

