/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.dsl.runtime;

import fr.cnav.saturne.ExternalFunctionDefinition;
import fr.cnav.saturne.RulesConfiguration;
import fr.cnav.saturne.dsl.runtime.BuiltinFunctions;
import fr.cnav.saturne.dsl.runtime.BuiltinFunctionsExtractor;
import fr.cnav.saturne.dsl.runtime.Description;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;

public class RulesConfigurationUtil {
    public void updateExternalFunctionsWithBuiltinFunctions(RulesConfiguration rulesConfiguration) {
        BuiltinFunctionsExtractor builtinFunctionsExtractor = new BuiltinFunctionsExtractor(rulesConfiguration);
        Method[] builtinFunctions = builtinFunctionsExtractor.getOrderedBuiltinFunctions(BuiltinFunctions.class);
        EList existingFunctionDefinitions = rulesConfiguration.getExternalFunctions();
        if (!existingFunctionDefinitions.isEmpty()) {
            Method[] methodArray = builtinFunctions;
            int n = builtinFunctions.length;
            int n2 = 0;
            while (n2 < n) {
                Method builtinFunction = methodArray[n2];
                this.updateExistingExtFunctionsWithBuiltinFunction(builtinFunctionsExtractor, (List<ExternalFunctionDefinition>)existingFunctionDefinitions, builtinFunction, rulesConfiguration);
                ++n2;
            }
        } else {
            List newExternalFunctionDefinitions = Arrays.stream(builtinFunctions).map(m -> builtinFunctionsExtractor.extractExternalFunctionFromBuiltinFunction((Method)m)).map(ExternalFunctionDefinition.class::cast).filter(b -> b != null).collect(Collectors.toList());
            rulesConfiguration.getExternalFunctions().addAll(newExternalFunctionDefinitions);
        }
    }

    private void updateExistingExtFunctionsWithBuiltinFunction(BuiltinFunctionsExtractor builtinFunctionsExtractor, List<ExternalFunctionDefinition> existingDefinitions, Method builtinFunction, RulesConfiguration rulesConfiguration) {
        ExternalFunctionDefinition buitinFunctionDefinition = builtinFunctionsExtractor.getBuitlintFunctionFromExternalFunction(existingDefinitions, builtinFunction);
        if (buitinFunctionDefinition != null) {
            this.updateExternalFunctionWithSpecAndComments(builtinFunction, buitinFunctionDefinition);
        } else {
            ExternalFunctionDefinition funcDef = builtinFunctionsExtractor.extractExternalFunctionFromBuiltinFunction(builtinFunction);
            if (funcDef != null) {
                rulesConfiguration.getExternalFunctions().add((Object)funcDef);
            }
        }
    }

    private void updateExternalFunctionWithSpecAndComments(Method builtinFunction, ExternalFunctionDefinition externalFunctionDefinition) {
        Description description = builtinFunction.getAnnotation(Description.class);
        if (description != null) {
            String parameters = description.parameters();
            String funcDefComment = externalFunctionDefinition.getComment();
            if (parameters != null && !parameters.equals(funcDefComment)) {
                externalFunctionDefinition.setComment(parameters);
            }
            String specification = description.description();
            String funcDefSpec = externalFunctionDefinition.getSpecification();
            if (specification != null && !specification.equals(funcDefSpec)) {
                externalFunctionDefinition.setSpecification(specification);
            }
        }
    }
}

