/*
 * Decompiled with CFR 0.152.
 */
package n4ds.dsn.serializer.html.exporter.provider.html;

import fr.cnav.saturne.report.model.Anomaly;
import fr.cnav.saturne.report.model.Context;
import fr.cnav.saturne.report.model.ContextField;
import fr.cnav.saturne.validator.message.MessageBlock;
import fr.cnav.saturne.validator.message.api.IMessageBlock;
import fr.cnav.saturne.validator.message.api.IMessageField;
import fr.cnav.saturne.validator.report.IReportLogger;
import java.util.List;
import java.util.TreeMap;
import n4ds.dsn.serializer.html.exporter.provider.IDSNExportProvider;

public class DSNExportProvider
implements IDSNExportProvider {
    private static final String EMPLOYEE_LABEL_1 = "Nom";
    private static final String EMPLOYEE_FIELD_QUALIFIED_ID_1 = "S21.G00.30.002";
    private static final String EMPLOYEE_LABEL_2 = "Pr\u00e9nom";
    private static final String EMPLOYEE_FIELD_QUALIFIED_ID_2 = "S21.G00.30.004";
    private static final String EMPLOYEE_LABEL_3 = "Nom d'usage";
    private static final String EMPLOYEE_FIELD_QUALIFIED_ID_3 = "S21.G00.30.003";
    private static final String EMPLOYEE_LABEL_4 = "NIR / Mat";
    private static final String EMPLOYEE_FIELD_QUALIFIED_ID_4 = "S21.G00.30.001";
    private static final String EMPLOYEE_FIELD_QUALIFIED_ID_4_2 = "S21.G00.80.003";
    private static final String EMPLOYEE_SUBGROUP_LABEL = "Salari\u00e9s";
    private static final String SEPARATOR = "/";
    private final IReportLogger reportLogger;
    private String siret;

    public DSNExportProvider(IReportLogger reportLogger) {
        this.reportLogger = reportLogger;
    }

    @Override
    public TreeMap<Integer, Object> getExportData(Object anomalie, boolean isDeclarationAnomaly) {
        if (anomalie instanceof Anomaly && isDeclarationAnomaly) {
            return this.getExportDataDeclarationAnomaly((Anomaly)anomalie);
        }
        if (anomalie instanceof Anomaly && !isDeclarationAnomaly) {
            return this.getExportDataEnvoiAnomaly((Anomaly)anomalie);
        }
        return new TreeMap<Integer, Object>();
    }

    protected TreeMap<Integer, Object> getExportDataEnvoiAnomaly(Anomaly envoiAnomaly) {
        return this.getExportValues(envoiAnomaly);
    }

    protected TreeMap<Integer, Object> getExportDataDeclarationAnomaly(Anomaly declAnomaly) {
        return this.getExportValues(declAnomaly);
    }

    protected TreeMap<Integer, Object> getExportValues(Anomaly anomaly) {
        TreeMap<Integer, Object> intToValue = new TreeMap<Integer, Object>();
        intToValue.put(0, anomaly.getCode() != null ? anomaly.getCode() : "");
        intToValue.put(1, anomaly.getFieldId() != null ? anomaly.getFieldId() : "");
        intToValue.put(2, anomaly.getFieldLabel() != null ? anomaly.getFieldLabel() : "");
        intToValue.put(3, anomaly.getFieldValue() != null ? anomaly.getFieldValue() : "");
        intToValue.put(4, String.valueOf(anomaly.getFieldLocalizer().getLineNumber()) != null ? String.valueOf(anomaly.getFieldLocalizer().getLineNumber()) : "");
        intToValue.put(5, String.valueOf(anomaly.getFieldLocalizer().getLineNumber()) != null ? String.valueOf(anomaly.getNumber()) : "");
        intToValue.put(6, anomaly.getMessage() != null ? anomaly.getMessage() : "");
        return intToValue;
    }

    @Override
    public TreeMap<Integer, Object> getHeaderExportDataFromSalarieContext(Context employeeContext) {
        if (employeeContext == null) {
            return this.getHeaderExportValues();
        }
        return this.getExportHeaderSalarieData(employeeContext);
    }

    @Override
    public TreeMap<Integer, Object> getHeaderExportData(Context declaration) {
        if (declaration == null) {
            return this.getHeaderExportValues();
        }
        return this.getExportHeaderDeclarationAnomalieData(declaration);
    }

    protected TreeMap<Integer, Object> getExportHeaderDeclarationAnomalieData(Context declaration) {
        List secondLevelFieldContexts = declaration.getContextFields();
        TreeMap<Integer, Object> intToValue = new TreeMap<Integer, Object>();
        intToValue.put(0, declaration.getRank());
        for (ContextField secondLevelContext : secondLevelFieldContexts) {
            if ("nature".equals(secondLevelContext.getReportSerializationName())) {
                intToValue.put(1, secondLevelContext.getValue());
                continue;
            }
            if ("type".equals(secondLevelContext.getReportSerializationName())) {
                intToValue.put(2, secondLevelContext.getValue());
                continue;
            }
            if ("SIREN".equals(secondLevelContext.getReportSerializationName())) {
                intToValue.put(3, secondLevelContext.getValue());
                continue;
            }
            if (!"nic_siege".equals(secondLevelContext.getReportSerializationName())) continue;
            intToValue.put(4, secondLevelContext.getValue());
        }
        return intToValue;
    }

    protected TreeMap<Integer, Object> getExportHeaderSalarieData(Context thirdLevelContext) {
        TreeMap<Integer, Object> intToValue = new TreeMap<Integer, Object>();
        intToValue.put(0, EMPLOYEE_SUBGROUP_LABEL);
        intToValue.put(1, EMPLOYEE_LABEL_1);
        intToValue.put(2, EMPLOYEE_LABEL_2);
        intToValue.put(3, EMPLOYEE_LABEL_3);
        intToValue.put(4, EMPLOYEE_LABEL_4);
        List thirdLevelContexts = thirdLevelContext.getContextFields();
        String nir = "";
        String matricule = "";
        for (ContextField thirdLevelFieldContext : thirdLevelContexts) {
            if ("nom_famille".equals(thirdLevelFieldContext.getReportSerializationName())) {
                intToValue.put(5, thirdLevelFieldContext.getValue());
                continue;
            }
            if ("prenoms".equals(thirdLevelFieldContext.getReportSerializationName())) {
                intToValue.put(6, thirdLevelFieldContext.getValue());
                continue;
            }
            if ("nom_usage".equals(thirdLevelFieldContext.getReportSerializationName())) {
                intToValue.put(7, thirdLevelFieldContext.getValue());
                continue;
            }
            if ("NIR".equals(thirdLevelFieldContext.getReportSerializationName())) {
                nir = thirdLevelFieldContext.getValue();
                continue;
            }
            if (!"matricule".equals(thirdLevelFieldContext.getReportSerializationName())) continue;
            matricule = thirdLevelFieldContext.getValue();
        }
        intToValue.put(8, String.valueOf(nir) + SEPARATOR + matricule);
        return intToValue;
    }

    public String getIndividualValue(MessageBlock subGroup, List<String> employeeFieldsQualifiedIds) {
        String finalValue = "";
        if (subGroup != null && employeeFieldsQualifiedIds != null) {
            String individualValue = this.getIndividualValue(subGroup, employeeFieldsQualifiedIds.get(0));
            if (individualValue != null) {
                finalValue = String.valueOf(finalValue) + individualValue;
            }
            if (employeeFieldsQualifiedIds.size() >= 2) {
                finalValue = String.valueOf(finalValue) + SEPARATOR;
                individualValue = this.getIndividualValue(subGroup, employeeFieldsQualifiedIds.get(1));
                if (individualValue != null) {
                    finalValue = String.valueOf(finalValue) + individualValue;
                }
            }
            return finalValue;
        }
        return "";
    }

    public String getIndividualValue(MessageBlock individualSubGroup, String employeeFieldQualifiedId) {
        String resultValue = null;
        if (individualSubGroup != null && employeeFieldQualifiedId != null) {
            List children = individualSubGroup.getChildren();
            for (List list : children) {
                for (IMessageBlock messageBlock : list) {
                    messageBlock.getFields();
                    List fields = messageBlock.getFields();
                    for (IMessageField messageField : fields) {
                        if (employeeFieldQualifiedId.equals(messageField.getStandardFieldDescription().getFullQualifiedId())) {
                            return messageField.getValueAsString();
                        }
                        resultValue = this.getIndividualValue(individualSubGroup, employeeFieldQualifiedId);
                        if (resultValue == null) continue;
                        return resultValue;
                    }
                }
            }
        }
        return resultValue;
    }

    public TreeMap<Integer, Object> getHeaderExportValues() {
        TreeMap<Integer, Object> intToValue = new TreeMap<Integer, Object>();
        intToValue.put(0, this.reportLogger.getReport().getValidationId());
        intToValue.put(1, this.getState());
        intToValue.put(2, String.valueOf(this.reportLogger.getAnomaliesNumber()));
        intToValue.put(3, String.valueOf(this.reportLogger.getReport().getRootContext().getContextChildren().size()));
        intToValue.put(4, String.valueOf(this.getThirdLevelContextNumber(this.reportLogger.getReport().getRootContext())));
        intToValue.put(5, this.getSiret(this.reportLogger.getReport().getRootContext()) != null ? this.getSiret(this.reportLogger.getReport().getRootContext()) : "");
        return intToValue;
    }

    private String getSiret(Context rootContext) {
        if (this.siret != null) {
            return this.siret;
        }
        String siren = "";
        String nic = "";
        List contextFields = rootContext.getContextFields();
        for (ContextField contextField : contextFields) {
            if ("siren".equals(contextField.getReportSerializationName())) {
                siren = contextField.getValue();
                continue;
            }
            if (!"nic".equals(contextField.getReportSerializationName())) continue;
            nic = contextField.getValue();
        }
        this.siret = String.valueOf(siren) + nic;
        return this.siret;
    }

    private int getThirdLevelContextNumber(Context rootContext) {
        List secondLevelContexts = rootContext.getContextChildren();
        int thirdLevelContextNumber = 0;
        for (Context secondLevelContext : secondLevelContexts) {
            thirdLevelContextNumber += secondLevelContext.getContextChildren().size();
        }
        return thirdLevelContextNumber;
    }

    public String getState() {
        if (this.reportLogger.getReport().getRootContext().isValid()) {
            return "OK";
        }
        return "KO";
    }

    @Override
    public TreeMap<Integer, Object> getFooterExportData(Object objet) {
        return new TreeMap<Integer, Object>();
    }
}

