/*
 * Decompiled with CFR 0.152.
 */
package n4ds.dsn.serializer.html;

import fr.cnav.saturne.Standard;
import fr.cnav.saturne.api.model.access.StandardAccessor;
import fr.cnav.saturne.options.OptionMap;
import fr.cnav.saturne.report.model.Anomaly;
import fr.cnav.saturne.report.model.Context;
import fr.cnav.saturne.validator.report.IReportLogger;
import fr.cnav.saturne.validator.report.SerializationException;
import fr.cnav.saturne.validator.report.impl.DsnReportLogger;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.TreeMap;
import n4ds.dsn.serializer.html.HTMLSerializerException;
import n4ds.dsn.serializer.html.MessagesSerializer;
import n4ds.dsn.serializer.html.exporter.HTMLParser;
import n4ds.dsn.serializer.html.exporter.parser.AbstractDSNExport;
import n4ds.dsn.serializer.html.exporter.provider.IExportInputTemplateProvider;
import n4ds.dsn.serializer.html.exporter.provider.html.DSNExportProvider;
import n4ds.dsn.serializer.html.exporter.provider.html.HTMLExportInputTemplateProvider;

public class HTMLSerializer
extends AbstractDSNExport {
    private HTMLExportInputTemplateProvider specificInputTemplateProvider;

    protected void exportDeclarationAnomalieWithSalarie(BufferedWriter exportResult, Context declaration) throws IOException {
        List thirdLevelContexts = declaration.getContextChildren();
        for (Context thirdLevelContext : thirdLevelContexts) {
            TreeMap<Integer, Object> intToValueHeader = this.getExportProvider().getHeaderExportDataFromSalarieContext(thirdLevelContext);
            exportResult.append(new HTMLParser(this.getInputTemplateProvider().getTemplatesDeclarationAnomalieSalarieHeader(), intToValueHeader, null, null).print());
            for (Anomaly declAnomalie : thirdLevelContext.getAnomalies()) {
                this.exportAnomalie(declAnomalie, this.getInputTemplateProvider().getTemplatesDeclarationAnomalieSalarie(), exportResult, true);
            }
            List contractContexts = thirdLevelContext.getContextChildren();
            for (Context context : contractContexts) {
                List contractAnomalies = context.getAnomalies();
                for (Anomaly anomaly : contractAnomalies) {
                    this.exportAnomalie(anomaly, this.getInputTemplateProvider().getTemplatesDeclarationAnomalieSalarie(), exportResult, true);
                }
            }
            exportResult.append(new HTMLParser(this.getInputTemplateProvider().getTemplatesDeclarationAnomalieSalarieFooter()).print());
        }
    }

    protected void exportDeclarationAnomalie(BufferedWriter exportResult, List<Anomaly> anomalies, Context declaration) throws IOException {
        if (!anomalies.isEmpty()) {
            TreeMap<Integer, Object> intToValueHeader = this.getExportProvider().getHeaderExportData(declaration);
            intToValueHeader.put(5, this.getDeclarationAnomaliesNumber(declaration));
            exportResult.append(new HTMLParser(this.getInputTemplateProvider().getTemplatesDeclarationAnomalieHeader(), intToValueHeader, null, null).print());
        }
        for (Anomaly declAnomalie : anomalies) {
            this.exportAnomalie(declAnomalie, this.getInputTemplateProvider().getTemplatesDeclarationAnomalie(), exportResult, true);
        }
        if (!anomalies.isEmpty()) {
            exportResult.append(new HTMLParser(this.getInputTemplateProvider().getTemplatesDeclarationAnomalieFooter()).print());
        }
        this.exportDeclarationAnomalieWithSalarie(exportResult, declaration);
    }

    private int getDeclarationAnomaliesNumber(Context context) {
        int anomaliesNumber = 0;
        List anomalies = context.getAnomalies();
        for (Anomaly anomaly : anomalies) {
            anomaliesNumber += anomaly.getNumber();
        }
        List subContexts = context.getContextChildren();
        for (Context subContext : subContexts) {
            anomaliesNumber += this.getDeclarationAnomaliesNumber(subContext);
        }
        return anomaliesNumber;
    }

    protected void exportEnvoiAnomalies(BufferedWriter exportResult) throws IOException {
        if (this.getRapport().getReport().getRootContext() == null) {
            return;
        }
        List envoiAnomalies = this.getRapport().getReport().getRootContext().getAnomalies();
        if (!envoiAnomalies.isEmpty()) {
            exportResult.append(new HTMLParser(this.getInputTemplateProvider().getTemplatesEnvoiAnomalieHeader()).print());
        }
        for (Anomaly envoiAnomalie : envoiAnomalies) {
            this.exportAnomalie(envoiAnomalie, this.getInputTemplateProvider().getTemplatesEnvoiAnomalie(), exportResult, false);
        }
        if (!envoiAnomalies.isEmpty()) {
            exportResult.append(new HTMLParser(this.getInputTemplateProvider().getTemplatesEnvoiAnomalieFooter()).print());
        }
    }

    public void exportAnomalie(Object anomalie, List<String> templates, BufferedWriter exportResult, boolean isDeclarationAnomaly) throws IOException {
        exportResult.append(new HTMLParser(templates, this.getExportProvider().getExportData(anomalie, isDeclarationAnomaly), null, null).print());
    }

    public void setInputTemplateProvider() {
        IExportInputTemplateProvider inputTemplateProvider = super.getInputTemplateProvider();
        this.specificInputTemplateProvider = inputTemplateProvider instanceof HTMLExportInputTemplateProvider ? (HTMLExportInputTemplateProvider)inputTemplateProvider : new HTMLExportInputTemplateProvider();
    }

    @Override
    public HTMLExportInputTemplateProvider getInputTemplateProvider() {
        return this.specificInputTemplateProvider;
    }

    @Override
    protected void init() throws HTMLSerializerException {
        this.setInputTemplateProvider(new HTMLExportInputTemplateProvider());
        this.inputTemplateProvider.importTemplates();
        this.setExportProvider(new DSNExportProvider(this.reportLogger));
        this.setInputTemplateProvider();
    }

    public void serialize(OutputStream outputStream, IReportLogger reportLogger, String namespacePrefix, String namespace, StandardAccessor modelAccessor) throws SerializationException {
        this.reportLogger = reportLogger;
        this.init();
        try {
            BufferedWriter exportResult = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
            HTMLParser parser = new HTMLParser(this.getInputTemplateProvider().getTemplatesHeader(), null, this.getExportProvider().getHeaderExportDataFromSalarieContext(null), null);
            exportResult.append(parser.print());
            this.exportEnvoiAnomalies(exportResult);
            for (Context declaration : this.getRapport().getReport().getRootContext().getContextChildren()) {
                this.exportDeclarationAnomalie(exportResult, declaration.getAnomalies(), declaration);
            }
            parser = new HTMLParser(this.getInputTemplateProvider().getTemplatesFooter());
            exportResult.append(parser.print());
            exportResult.flush();
        }
        catch (UnsupportedEncodingException e) {
            throw new SerializationException(MessagesSerializer.ErrorSerialization, (Throwable)e);
        }
        catch (IOException e) {
            throw new SerializationException();
        }
    }

    public IReportLogger getReportLogger(Standard theStandard, boolean calculateContextsDuringParsing, OptionMap optionsMap) {
        return new DsnReportLogger(theStandard, calculateContextsDuringParsing, optionsMap);
    }
}

