/*
 * Decompiled with CFR 0.152.
 */
package n4ds.dsn.serializer.csv;

import com.opencsv.CSVWriter;
import fr.cnav.saturne.ModelAccessor;
import fr.cnav.saturne.report.model.Anomaly;
import fr.cnav.saturne.report.model.Context;
import fr.cnav.saturne.report.model.ContextField;
import fr.cnav.saturne.validator.report.IReportLogger;
import fr.cnav.saturne.validator.report.impl.ConfigurationDsn;
import fr.cnav.saturne.validator.report.impl.DsnAnomalyComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;

public class CSVSerializer {
    public static final String A_TYPE = new String("A");
    public static final String D_TYPE = new String("D");
    public static final String G_TYPE = new String("G");
    public static final String E_TYPE = new String("E");
    private CSVWriter writer;
    private int nb_ano_bloquante;
    private int nb_ano_nonbloquante;
    private int nbAnoBloquante;
    private int nbAnoNonbloquante;
    private final Context report;
    private final IReportLogger reportLogger;
    private ModelAccessor accessor;

    public CSVSerializer(CSVWriter writer, IReportLogger reportLogger, ModelAccessor accessor) {
        this.writer = writer;
        this.report = reportLogger.getReport().getRootContext();
        this.reportLogger = reportLogger;
        this.accessor = accessor;
    }

    public void serialize() throws XMLStreamException {
        this.serializeEnvoiIdentification();
        this.serializeEnvoiAnomalies();
        List declarations = this.report.getContextChildren();
        for (Context secondLevelContext : declarations) {
            this.serializeSecondLevelContext(secondLevelContext);
        }
    }

    private void serializeSecondLevelContext(Context secondLevelContext) {
        List categories = secondLevelContext.getContextFields();
        String rangDeclaration = Integer.toString(secondLevelContext.getRank());
        this.nbAnoBloquante = 0;
        this.nbAnoNonbloquante = 0;
        this.calculatesBlockingAndNoBlockingAnomaliesNumbers(secondLevelContext, 2);
        ArrayList<String> strlistDeclaration = new ArrayList<String>();
        String rang_declaration = "";
        String nature_declaration = "";
        String type_declaration = "";
        String fraction_declaration = "";
        String mois_declaration = "";
        String ordre_declaration = "";
        String SIREN_entreprise = "";
        String NIC_entreprise = "";
        String NIC_etablissement = "";
        String etatDeclaration = "";
        int nb_salarie = 0;
        rang_declaration = rangDeclaration;
        ContextField contextFieldSiren = null;
        ContextField contextFieldNicSiege = null;
        ContextField contextFieldNicAffection = null;
        for (ContextField contextField : categories) {
            if (contextField.getReportSerializationName().equals("nic_siege")) {
                contextFieldNicSiege = contextField;
                continue;
            }
            if (contextField.getReportSerializationName().equals("nic_affectation")) {
                contextFieldNicAffection = contextField;
                continue;
            }
            if (contextField.getReportSerializationName().equals("SIREN")) {
                contextFieldSiren = contextField;
                continue;
            }
            if (contextField.getReportSerializationName().equalsIgnoreCase("nature")) {
                nature_declaration = contextField.getValue();
            }
            if (contextField.getReportSerializationName().equalsIgnoreCase("type")) {
                type_declaration = contextField.getValue();
            }
            if (contextField.getReportSerializationName().equalsIgnoreCase("ordre")) {
                ordre_declaration = contextField.getValue();
            }
            if (contextField.getReportSerializationName().equalsIgnoreCase("fraction")) {
                fraction_declaration = contextField.getValue();
            }
            if (!contextField.getReportSerializationName().equalsIgnoreCase("mois")) continue;
            mois_declaration = contextField.getValue();
        }
        SIREN_entreprise = contextFieldSiren == null ? "" : contextFieldSiren.getValue();
        NIC_entreprise = contextFieldNicSiege == null ? "" : contextFieldNicSiege.getValue();
        NIC_etablissement = contextFieldNicAffection == null ? "" : contextFieldNicAffection.getValue();
        etatDeclaration = this.nbAnoBloquante == 0 && secondLevelContext.isValid() && (this.report.getAnomalies().size() <= 0 || !"LIM000".equals(((Anomaly)this.report.getAnomalies().get(this.report.getAnomalies().size() - 1)).getCode())) ? "OK" : "KO";
        strlistDeclaration.add(D_TYPE);
        strlistDeclaration.add(rang_declaration);
        strlistDeclaration.add(nature_declaration);
        strlistDeclaration.add(type_declaration);
        strlistDeclaration.add(fraction_declaration);
        strlistDeclaration.add(ordre_declaration);
        strlistDeclaration.add(mois_declaration);
        strlistDeclaration.add(SIREN_entreprise);
        strlistDeclaration.add(NIC_entreprise);
        strlistDeclaration.add(NIC_etablissement);
        strlistDeclaration.add(etatDeclaration);
        strlistDeclaration.add(Integer.toString(nb_salarie));
        strlistDeclaration.add(Integer.toString(this.nb_ano_bloquante));
        strlistDeclaration.add(Integer.toString(this.nb_ano_nonbloquante));
        this.writer.writeNext(this.list_To_tabString(strlistDeclaration));
        strlistDeclaration.clear();
        Map<String, Integer> reportSerializationNameToNumberInContext = this.calculateSubContextNumber(secondLevelContext);
        if (reportSerializationNameToNumberInContext.isEmpty()) {
            throw new IllegalStateException("The norm model should have a third level context for the second level one.");
        }
        String thirdLevelContextReportSerializationName = reportSerializationNameToNumberInContext.keySet().iterator().next();
        List anomalies = secondLevelContext.getAnomalies();
        Collections.sort(anomalies, new DsnAnomalyComparator());
        for (Anomaly currentAnomaly : anomalies) {
            String code = "";
            String categorie = "";
            String message = "";
            String numero_ligne = "";
            String rubrique_id = "";
            String rubrique_libelle = "";
            String rubrique_valeur = "";
            ArrayList<String> strlistAnomalieStructure = new ArrayList<String>();
            code = currentAnomaly.getCode() == null || "".equals(currentAnomaly.getCode()) ? "" : currentAnomaly.getCode();
            categorie = !currentAnomaly.isBlocking() ? "non-bloquant" : "bloquant";
            message = currentAnomaly.getMessage() == null || "".equals(currentAnomaly.getMessage()) ? "" : currentAnomaly.getMessage();
            numero_ligne = String.valueOf(currentAnomaly.getFieldLocalizer().getLineNumber());
            currentAnomaly.getNumber();
            if (currentAnomaly.getFieldId() != null) {
                rubrique_id = currentAnomaly.getFieldId();
            }
            if (currentAnomaly.getFieldLabel() != null) {
                rubrique_libelle = currentAnomaly.getFieldLabel();
            }
            if (currentAnomaly.getFieldValue() != null) {
                rubrique_valeur = currentAnomaly.getFieldValue();
            }
            strlistAnomalieStructure.add(A_TYPE);
            strlistAnomalieStructure.add(code);
            strlistAnomalieStructure.add(categorie);
            strlistAnomalieStructure.add(message);
            strlistAnomalieStructure.add(numero_ligne);
            strlistAnomalieStructure.add(rubrique_id);
            strlistAnomalieStructure.add(rubrique_libelle);
            strlistAnomalieStructure.add(rubrique_valeur);
            this.writer.writeNext(this.list_To_tabString(strlistAnomalieStructure));
            strlistAnomalieStructure.clear();
        }
        List employeeContexts = secondLevelContext.getContextChildren();
        for (Context employeeContext : employeeContexts) {
            this.serializesDeclarationAnomalies(thirdLevelContextReportSerializationName, employeeContext, null);
            List contractContexts = employeeContext.getContextChildren();
            for (Context contractContext : contractContexts) {
                this.serializesDeclarationAnomalies(thirdLevelContextReportSerializationName, employeeContext, contractContext);
            }
        }
    }

    private void calculatesBlockingAndNoBlockingAnomaliesNumbers(Context secondLevelContext, int level) {
        List anomalies = secondLevelContext.getAnomalies();
        for (Anomaly anomaly : anomalies) {
            if (!anomaly.isBlocking()) {
                this.nb_ano_bloquante += anomaly.getNumber();
                continue;
            }
            this.nb_ano_nonbloquante += anomaly.getNumber();
        }
        if (level <= 3) {
            List subContexts = secondLevelContext.getContextChildren();
            for (Context context : subContexts) {
                this.calculatesBlockingAndNoBlockingAnomaliesNumbers(context, level + 1);
            }
        }
    }

    private int calculateDeclarationAnomaliesNumber(Context context) {
        int anomaliesNumber = context.getAnomalies().size();
        List contextChildren = context.getContextChildren();
        for (Context subContext : contextChildren) {
            anomaliesNumber += this.calculateDeclarationAnomaliesNumber(subContext);
        }
        return anomaliesNumber;
    }

    private int getThirdLevelContextNumber(Context rootContext) {
        List subContexts = rootContext.getContextChildren();
        int thirdLevelContextNumber = 0;
        for (Context subContext : subContexts) {
            thirdLevelContextNumber += subContext.getContextChildren().size();
        }
        return thirdLevelContextNumber;
    }

    private void serializeEnvoiIdentification() {
        List declarations = this.report.getContextChildren();
        int nbAnoDeclaration = 0;
        for (Context context : declarations) {
            nbAnoDeclaration += this.calculateDeclarationAnomaliesNumber(context);
        }
        int nbAnoEnvoi = 0;
        List envoiAnomalies = this.report.getAnomalies();
        for (Anomaly anomaly : envoiAnomalies) {
            nbAnoEnvoi += anomaly.getNumber();
        }
        int nbAnoTotal = nbAnoEnvoi + nbAnoDeclaration;
        ArrayList<String> strlistEnvoie = new ArrayList<String>();
        List categories = this.report.getContextFields();
        String version_norme = "";
        String version_produit = "";
        String horodatage = ConfigurationDsn.getTimeStamp();
        String point_de_depot = "";
        String type_envoi = "";
        String essai_reel = "";
        String emetteur_siren = "";
        String emetteur_nic = "";
        String emetteur_siret = "";
        String nom_logiciel = "";
        String editeur_logiciel = "";
        String etat_envoi = "";
        for (ContextField category : categories) {
            if (category.getReportSerializationName().equals("version_norme") && category.getValue() != null) {
                version_norme = category.getValue();
            }
            if (this.accessor.getStandard().getDescription() != null) {
                version_produit = this.accessor.getStandard().getDescription();
                continue;
            }
            if (category.getReportSerializationName().equals("point_de_depot") && category.getValue() != null) {
                point_de_depot = category.getValue();
                continue;
            }
            if (category.getReportSerializationName().equals("type_envoi") && category.getValue() != null) {
                type_envoi = category.getValue();
                continue;
            }
            if (category.getReportSerializationName().equals("essai_reel") && category.getValue() != null) {
                essai_reel = category.getValue();
                continue;
            }
            if (category.getReportSerializationName().equals("siren") && category.getValue() != null) {
                emetteur_siren = category.getValue();
                continue;
            }
            if (category.getReportSerializationName().equals("nic") && category.getValue() != null) {
                emetteur_nic = category.getValue();
                continue;
            }
            if (category.getReportSerializationName().equals("nom_logiciel") && category.getValue() != null) {
                nom_logiciel = category.getValue();
                continue;
            }
            if (!category.getReportSerializationName().equals("editeur_logiciel") || category.getValue() == null) continue;
            editeur_logiciel = category.getValue();
        }
        strlistEnvoie.add(E_TYPE);
        strlistEnvoie.add(this.reportLogger.getCustomAttributeValue("fr.cnav.saturne.validator.report.validationIdAttributeKey"));
        if (!version_norme.equals("")) {
            strlistEnvoie.add(version_norme);
        }
        strlistEnvoie.add(version_produit);
        strlistEnvoie.add(horodatage);
        if (!point_de_depot.equals("")) {
            strlistEnvoie.add(point_de_depot);
        }
        if (!type_envoi.equals("")) {
            strlistEnvoie.add(type_envoi);
        }
        if (!essai_reel.equals("")) {
            strlistEnvoie.add(essai_reel);
        }
        emetteur_siret = emetteur_siren.concat(emetteur_nic);
        strlistEnvoie.add(emetteur_siret);
        if (!nom_logiciel.equals("")) {
            strlistEnvoie.add(nom_logiciel);
        }
        etat_envoi = this.report.isValid() ? "OK" : "KO";
        strlistEnvoie.add(etat_envoi);
        strlistEnvoie.add(Integer.toString(declarations.size()));
        strlistEnvoie.add(Integer.toString(this.getThirdLevelContextNumber(this.report)));
        strlistEnvoie.add(Integer.toString(nbAnoEnvoi));
        strlistEnvoie.add(Integer.toString(nbAnoDeclaration));
        strlistEnvoie.add(Integer.toString(nbAnoTotal));
        this.writer.writeNext(this.list_To_tabString(strlistEnvoie));
    }

    private void serializeEnvoiAnomalies() {
        ArrayList<String> strlistEnvoiAnomalie = new ArrayList<String>();
        String code = "";
        String categorie = "";
        String message = "";
        String numero_ligne = "";
        String rubrique_id = "";
        String rubrique_libelle = "";
        String rubrique_valeur = "";
        for (Anomaly anomaly : this.report.getAnomalies()) {
            code = anomaly.getCode();
            categorie = !anomaly.isBlocking() ? "non-bloquant" : "bloquant";
            message = anomaly.getMessage();
            if (anomaly.getFieldLocalizer().getLineNumber() != 0) {
                numero_ligne = Integer.toString(anomaly.getFieldLocalizer().getLineNumber());
            }
            if (anomaly.getFieldId() != null) {
                rubrique_id = anomaly.getFieldId();
            }
            if (anomaly.getFieldLabel() != null) {
                rubrique_libelle = anomaly.getFieldLabel();
            }
            if (anomaly.getFieldValue() == null) continue;
            rubrique_valeur = anomaly.getFieldValue();
        }
        strlistEnvoiAnomalie.add(G_TYPE);
        strlistEnvoiAnomalie.add(code);
        strlistEnvoiAnomalie.add(categorie);
        strlistEnvoiAnomalie.add(message);
        strlistEnvoiAnomalie.add(numero_ligne);
        strlistEnvoiAnomalie.add(rubrique_id);
        strlistEnvoiAnomalie.add(rubrique_libelle);
        strlistEnvoiAnomalie.add(rubrique_valeur);
        this.writer.writeNext(this.list_To_tabString(strlistEnvoiAnomalie));
        strlistEnvoiAnomalie.clear();
    }

    private String[] list_To_tabString(List<String> strlist) {
        String[] strarray = new String[strlist.size()];
        return strlist.toArray(strarray);
    }

    private Map<String, Integer> calculateSubContextNumber(Context context) {
        List contextChildren = context.getContextChildren();
        HashMap<String, Integer> contextSerialisationNameToContextNumber = new HashMap<String, Integer>();
        Set directSubContextSerializationNames = this.reportLogger.geReportContextDescriptor().getDirectSubContextSerializationNames(context);
        for (String directSubContextSerializationName : directSubContextSerializationNames) {
            contextSerialisationNameToContextNumber.put(directSubContextSerializationName, new Integer(0));
        }
        for (Context subcontext : contextChildren) {
            Integer subContextNumber;
            Integer n = subContextNumber = (Integer)contextSerialisationNameToContextNumber.get(subcontext.getName());
            subContextNumber = n + 1;
            contextSerialisationNameToContextNumber.put(subcontext.getName(), n);
        }
        return contextSerialisationNameToContextNumber;
    }

    private void serializesDeclarationAnomalies(String contextReportSerializationName, Context employeeContext, Context contractContext) {
        List employeeContextFields = employeeContext.getContextFields();
        List anomalies = contractContext == null ? employeeContext.getAnomalies() : contractContext.getAnomalies();
        for (Anomaly currentAnomaly : anomalies) {
            String nir = "";
            String nomUsage = "";
            String nomFamille = "";
            String prenoms = "";
            String sexe = "";
            String dateNaissance = "";
            String lieuNaissance = "";
            String codePays = "";
            String matricule = "";
            String rang = "";
            String ntt = "";
            String dateDebutContrat = "";
            String numeroContrat = "";
            String codeAnomalie = "";
            String bloquantAnomalie = "";
            String messageAnomalie = "";
            String numeroLigneAnomalie = "";
            String rubriqueDeclenchante = "";
            String rubriqueLibelle = "";
            String valeur = "";
            ArrayList<String> strlistAnomalie = new ArrayList<String>();
            codeAnomalie = currentAnomaly.getCode() == null || "".equals(currentAnomaly.getCode()) ? "" : currentAnomaly.getCode();
            bloquantAnomalie = !currentAnomaly.isBlocking() ? "non-bloquant" : "bloquant";
            messageAnomalie = currentAnomaly.getMessage() == null || "".equals(currentAnomaly.getMessage()) ? "" : currentAnomaly.getMessage();
            numeroLigneAnomalie = String.valueOf(currentAnomaly.getFieldLocalizer().getLineNumber());
            if (currentAnomaly.getFieldId() != null) {
                rubriqueDeclenchante = currentAnomaly.getFieldId();
            }
            if (currentAnomaly.getFieldLabel() != null) {
                rubriqueLibelle = currentAnomaly.getFieldLabel();
            }
            if (currentAnomaly.getFieldValue() != null) {
                valeur = currentAnomaly.getFieldValue();
            }
            if (currentAnomaly.getFieldId() != null) {
                rang = String.valueOf(employeeContext.getRank());
                for (ContextField employeeContextField : employeeContextFields) {
                    if (employeeContextField.getReportSerializationName().equals("NIR") && employeeContextField.getValue() != null) {
                        nir = employeeContextField.getValue();
                    }
                    if (employeeContextField.getReportSerializationName().equals("nom_usage") && employeeContextField.getValue() != null) {
                        nomUsage = employeeContextField.getValue();
                    }
                    if (employeeContextField.getReportSerializationName().equals("nom_famille") && employeeContextField.getValue() != null) {
                        nomFamille = employeeContextField.getValue();
                    }
                    if (employeeContextField.getReportSerializationName().equals("prenoms") && employeeContextField.getValue() != null) {
                        prenoms = employeeContextField.getValue();
                    }
                    if (employeeContextField.getReportSerializationName().equals("sexe") && employeeContextField.getValue() != null) {
                        sexe = employeeContextField.getValue();
                    }
                    if (employeeContextField.getReportSerializationName().equals("date_naissance") && employeeContextField.getValue() != null) {
                        dateNaissance = employeeContextField.getValue();
                    }
                    if (employeeContextField.getReportSerializationName().equals("lieu_naissance") && employeeContextField.getValue() != null) {
                        lieuNaissance = employeeContextField.getValue();
                    }
                    if (employeeContextField.getReportSerializationName().equals("code_pays") && employeeContextField.getValue() != null) {
                        codePays = employeeContextField.getValue();
                    }
                    if (employeeContextField.getReportSerializationName().equals("matricule") && employeeContextField.getValue() != null) {
                        matricule = employeeContextField.getValue();
                    }
                    if (!employeeContextField.getReportSerializationName().equals("NTT") || employeeContextField.getValue() == null) continue;
                    ntt = employeeContextField.getValue();
                }
                if (contractContext != null) {
                    List contractContextFields = contractContext.getContextFields();
                    for (ContextField field : contractContextFields) {
                        if (field.getReportSerializationName().equals(ConfigurationDsn.REPORT_RUB_SALARIE_DATE_DEBUT_CONTRAT) && field.getValue() != null) {
                            dateDebutContrat = field.getValue();
                        }
                        if (!field.getReportSerializationName().equals(ConfigurationDsn.REPORT_RUB_SALARIE_DATE_NUMERO_CONTRAT) || field.getValue() == null) continue;
                        numeroContrat = field.getValue();
                    }
                }
            }
            strlistAnomalie.add(A_TYPE);
            strlistAnomalie.add(codeAnomalie);
            strlistAnomalie.add(bloquantAnomalie);
            strlistAnomalie.add(messageAnomalie);
            strlistAnomalie.add(numeroLigneAnomalie);
            strlistAnomalie.add(rubriqueDeclenchante);
            strlistAnomalie.add(rubriqueLibelle);
            strlistAnomalie.add(valeur);
            strlistAnomalie.add(nir);
            strlistAnomalie.add(nomFamille);
            strlistAnomalie.add(nomUsage);
            strlistAnomalie.add(prenoms);
            strlistAnomalie.add(sexe);
            strlistAnomalie.add(dateNaissance);
            strlistAnomalie.add(lieuNaissance);
            strlistAnomalie.add(matricule);
            strlistAnomalie.add(rang);
            strlistAnomalie.add(dateDebutContrat);
            strlistAnomalie.add(numeroContrat);
            this.writer.writeNext(this.list_To_tabString(strlistAnomalie));
            strlistAnomalie.clear();
        }
    }
}

