/*
 * Decompiled with CFR 0.152.
 */
package n4ds.dsn.serializer.csv;

import com.opencsv.CSVWriter;
import fr.cnav.saturne.ModelAccessor;
import fr.cnav.saturne.Standard;
import fr.cnav.saturne.api.model.access.StandardAccessor;
import fr.cnav.saturne.options.OptionMap;
import fr.cnav.saturne.validator.report.IReportLogger;
import fr.cnav.saturne.validator.report.IReportSerializer;
import fr.cnav.saturne.validator.report.SerializationException;
import fr.cnav.saturne.validator.report.impl.DsnReportLogger;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import n4ds.dsn.serializer.csv.CSVSerializer;

public class CSVReportSerializer
implements IReportSerializer {
    private IReportLogger dsnReportLogger;
    private CSVSerializer csvSerializer;
    private CSVWriter writer;
    private ModelAccessor modelAccessor;

    public void serialize(OutputStream outputStream, IReportLogger reportLogger, String namespacePrefix, String namespace, StandardAccessor modelAccessor) throws SerializationException {
        this.dsnReportLogger = reportLogger;
        if (outputStream != null) {
            try {
                this.writer = new CSVWriter((Writer)new OutputStreamWriter(outputStream, "iso-8859-1"), ';');
                this.csvSerializer = new CSVSerializer(this.writer, this.dsnReportLogger, (ModelAccessor)modelAccessor);
                this.csvSerializer.serialize();
                try {
                    this.writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (XMLStreamException e) {
                throw new SerializationException((Throwable)e);
            }
            catch (UnsupportedEncodingException e) {
                throw new SerializationException((Throwable)e);
            }
        } else {
            throw new IllegalArgumentException("Couldn't create stream writer.");
        }
    }

    public IReportLogger getReportLogger(Standard theStandard, boolean calculateContextsDuringParsing, OptionMap optionsMap) {
        return new DsnReportLogger(theStandard, calculateContextsDuringParsing, optionsMap);
    }
}

