/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.dsl.types.adapter;

import fr.cnav.saturne.dsl.formules.Not;
import fr.cnav.saturne.dsl.parser.Logging;
import fr.cnav.saturne.dsl.types.Type;
import fr.cnav.saturne.dsl.types.adapter.DSLTypeAdapter;
import fr.cnav.saturne.dsl.types.adapter.DSLTypeAdapterFactory;
import java.util.Map;
import java.util.logging.Level;

public class NotTypeAdapter
extends DSLTypeAdapter {
    @Override
    Type computeType(Type context, Map<String, Type> env) {
        Type result;
        assert (this.getTarget() instanceof Not);
        Not target = (Not)this.getTarget();
        DSLTypeAdapter adapter = DSLTypeAdapterFactory.adapt(target.getOperand());
        Type opType = adapter.getType(context, env);
        if (opType == Type.UNDEFINED) {
            this.setErrorMsg(adapter.getErrorMsg());
            result = Type.UNDEFINED;
        } else if (opType != Type.BOOLEAN) {
            this.setErrorMsg("N4DSType : Logical operator's operands must be of boolean type : " + (Object)((Object)opType));
            result = Type.UNDEFINED;
        } else {
            result = Type.BOOLEAN;
        }
        if (result == Type.UNDEFINED) {
            Logging.LOGGER.log(Level.SEVERE, this.getErrorMsg());
        }
        return result;
    }
}

