/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.api.model.access;

import fr.cnav.saturne.ModelAccessorWithNomenclaturesHandling;
import fr.cnav.saturne.Standard;
import fr.cnav.saturne.api.model.access.BlockDescription;
import fr.cnav.saturne.api.model.access.DataTypeDescription;
import fr.cnav.saturne.api.model.access.DataTypeSetDescription;
import fr.cnav.saturne.api.model.access.FieldDescription;
import fr.cnav.saturne.api.model.access.GenericRuleDescription;
import fr.cnav.saturne.api.model.access.HeaderBlockDescription;
import fr.cnav.saturne.api.model.access.MessageDescription;
import fr.cnav.saturne.api.model.access.RuleSetDescription;
import fr.cnav.saturne.api.model.access.StandardDescription;
import fr.cnav.saturne.options.OptionMap;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class StandardAccessor
extends ModelAccessorWithNomenclaturesHandling {
    private StandardDescription standardDescription;
    private Map<String, BlockDescription> fullQualifiedIdToBlock;
    private Map<String, FieldDescription> fullQualifiedIdToField;
    private Map<String, DataTypeDescription> idToDataTypes;
    private Map<String, GenericRuleDescription> fullIdToRules;

    public StandardAccessor(Standard theStandard, OptionMap options, Logger logger, String dataSourcePackage, Object knowledgeBaseObject) throws IOException {
        this(theStandard, options, logger, dataSourcePackage, knowledgeBaseObject.getClass().getClassLoader());
    }

    public StandardAccessor(Standard theStandard, OptionMap options, Logger logger, String dataSourcePackage, ClassLoader classLoader) throws IOException {
        super(theStandard, options, logger, dataSourcePackage, classLoader);
        this.standardDescription = new StandardDescription(theStandard);
        this.fullQualifiedIdToBlock = new HashMap<String, BlockDescription>();
        this.fullQualifiedIdToField = new HashMap<String, FieldDescription>();
        this.idToDataTypes = new HashMap<String, DataTypeDescription>();
        this.fullIdToRules = new HashMap<String, GenericRuleDescription>();
        if (this.standardDescription.getMessage() != null) {
            HeaderBlockDescription headerBlock = this.standardDescription.getMessage().getHeaderBlock();
            this.initMaps(headerBlock, logger);
            BlockDescription footerBlock = this.standardDescription.getMessage().getFooterBlock();
            this.initMaps(footerBlock, logger);
            this.createDataTypesMap();
            this.createRulesMap();
        }
    }

    public MessageDescription getMessageDescription() {
        return this.standardDescription.getMessage();
    }

    public StandardDescription getStandardDescription() {
        return this.standardDescription;
    }

    public BlockDescription getBlockDescription(String fullQualifiedId) {
        return this.fullQualifiedIdToBlock.get(fullQualifiedId);
    }

    public FieldDescription getFieldDescription(String fullQualifiedId) {
        return this.fullQualifiedIdToField.get(fullQualifiedId);
    }

    public GenericRuleDescription getRuleDescription(String fullId) {
        return this.fullIdToRules.get(fullId);
    }

    public DataTypeDescription getDataTypeDescription(String id) {
        return this.idToDataTypes.get(id);
    }

    private void initMaps(BlockDescription block, Logger logger) {
        if (block == null) {
            return;
        }
        String fullQualifiedId = block.getFullQualifiedId();
        if (fullQualifiedId == null) {
            logger.warning("Couldn't compute fullQualifiedId for block" + block.getName());
        } else {
            this.fullQualifiedIdToBlock.put(fullQualifiedId, block);
        }
        for (BlockDescription child : block.getChildrenBlocks()) {
            this.initMaps(child, logger);
        }
        for (FieldDescription field : block.getFields()) {
            String fieldQualifiedId = field.getFullQualifiedId();
            if (fieldQualifiedId == null) {
                logger.warning("Couldn't compute fullQualifiedId for field" + field.getName());
                continue;
            }
            this.fullQualifiedIdToField.put(fieldQualifiedId, field);
        }
    }

    private void createDataTypesMap() {
        this.idToDataTypes = new HashMap<String, DataTypeDescription>();
        DataTypeSetDescription dataTypes = this.standardDescription.getDataTypes();
        if (dataTypes != null) {
            for (DataTypeDescription type : dataTypes.getDatatypes()) {
                String id = type.getId();
                if (id == null) continue;
                this.idToDataTypes.put(type.getId(), type);
            }
        }
    }

    private void createRulesMap() {
        this.fullIdToRules = new HashMap<String, GenericRuleDescription>();
        RuleSetDescription rules = this.standardDescription.getRules();
        if (rules != null) {
            for (GenericRuleDescription rule : rules.getRules()) {
                String id = rule.getFullQualifiedId();
                if (id == null) continue;
                this.fullIdToRules.put(rule.getFullQualifiedId(), rule);
            }
        }
    }
}

