/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.api.model.access;

import fr.cnav.saturne.BlockRefinement;
import fr.cnav.saturne.Declaration;
import fr.cnav.saturne.Field;
import fr.cnav.saturne.FieldRefinement;
import fr.cnav.saturne.Refinement;
import fr.cnav.saturne.UsageType;
import fr.cnav.saturne.Value;
import fr.cnav.saturne.api.model.access.BlockDescription;
import fr.cnav.saturne.api.model.access.BlockRefinementDescription;
import fr.cnav.saturne.api.model.access.FieldDescription;
import fr.cnav.saturne.api.model.access.FieldRefinementDescription;
import fr.cnav.saturne.api.model.access.MessageElementDescription;
import fr.cnav.saturne.api.model.access.NamedElementDescription;
import fr.cnav.saturne.api.model.access.RefinementDescription;
import fr.cnav.saturne.api.model.access.StandardMapUtils;
import fr.cnav.saturne.api.model.access.ValueDescription;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;

public class DeclarationDescription
implements NamedElementDescription {
    private Declaration declaration;
    private Map<FieldDescription, List<ValueDescription>> keyValues;
    private Map<BlockDescription, BlockRefinementDescription> blockRefinements;
    private Map<FieldDescription, FieldRefinementDescription> fieldRefinements;
    private List<RefinementDescription> refinements;

    public DeclarationDescription(Declaration theDeclaration, StandardMapUtils standardMapUtils) {
        this.declaration = theDeclaration;
        this.computeRefinements(standardMapUtils);
        this.computeKeyValues(standardMapUtils);
        this.computeBlockRefinements();
        this.computeFieldRefinements();
    }

    public Map<FieldDescription, List<ValueDescription>> getKeyValues() {
        return this.keyValues;
    }

    public Map<BlockDescription, BlockRefinementDescription> getBlockRefinements() {
        return this.blockRefinements;
    }

    public Map<FieldDescription, FieldRefinementDescription> getFieldRefinements() {
        return this.fieldRefinements;
    }

    public List<RefinementDescription> getRefinements() {
        return this.refinements;
    }

    public int getBlockLowerBound(BlockDescription block) {
        BlockRefinementDescription refinement;
        if (block == null) {
            throw new IllegalArgumentException();
        }
        int blockLowerBound = this.getBlockRefinements().containsKey(block) ? ((refinement = this.getBlockRefinements().get(block)).getLowerBound() != null ? refinement.getLowerBound().getNewBound() : block.getLowerBound()) : block.getLowerBound();
        return blockLowerBound;
    }

    public int getBlockUpperBound(BlockDescription block) {
        BlockRefinementDescription refinement;
        if (block == null) {
            throw new IllegalArgumentException();
        }
        int blockUpperBound = this.getBlockRefinements().containsKey(block) ? ((refinement = this.getBlockRefinements().get(block)).getUpperBound() != null ? refinement.getUpperBound().getNewBound() : block.getUpperBound()) : block.getUpperBound();
        return blockUpperBound;
    }

    public UsageType getUsage(MessageElementDescription element) {
        if (element == null) {
            throw new IllegalArgumentException();
        }
        UsageType usageType = null;
        if (element instanceof FieldDescription && this.getFieldRefinements().containsKey(element)) {
            UsageType usage = this.getFieldRefinements().get(element).getUsage();
            usageType = UsageType.UNSET == usage ? element.getUsage() : usage;
        } else if (element instanceof BlockDescription && this.getBlockRefinements().containsKey(element)) {
            UsageType usage = this.getBlockRefinements().get(element).getUsage();
            usageType = UsageType.UNSET == usage ? element.getUsage() : usage;
        }
        if (usageType == null) {
            usageType = element.getUsage();
        }
        return usageType;
    }

    @Override
    public String getName() {
        return this.declaration.getName();
    }

    @Override
    public String getDescription() {
        return this.declaration.getDescription();
    }

    @Override
    public String getComment() {
        return this.declaration.getComment();
    }

    private void computeKeyValues(StandardMapUtils standardMapUtils) {
        this.keyValues = new HashMap<FieldDescription, List<ValueDescription>>();
        EMap<Field, EList<Value>> map = this.declaration.getKeyValues();
        Set keys = map.keySet();
        for (Field key : keys) {
            List values = (List)map.get((Object)key);
            ArrayList<ValueDescription> valuesReadAccess = new ArrayList<ValueDescription>();
            for (Value value : values) {
                valuesReadAccess.add(new ValueDescription(value));
            }
            this.keyValues.put(standardMapUtils.getFieldDescription(key.getFullQualifiedId()), valuesReadAccess);
        }
    }

    private void computeBlockRefinements() {
        this.blockRefinements = new HashMap<BlockDescription, BlockRefinementDescription>();
        for (RefinementDescription refinement : this.getRefinements()) {
            if (!(refinement instanceof BlockRefinementDescription)) continue;
            this.blockRefinements.put(((BlockRefinementDescription)refinement).getBlock(), (BlockRefinementDescription)refinement);
        }
    }

    private void computeFieldRefinements() {
        this.fieldRefinements = new HashMap<FieldDescription, FieldRefinementDescription>();
        for (RefinementDescription refinement : this.getRefinements()) {
            if (!(refinement instanceof FieldRefinementDescription)) continue;
            this.fieldRefinements.put(((FieldRefinementDescription)refinement).getField(), (FieldRefinementDescription)refinement);
        }
    }

    private void computeRefinements(StandardMapUtils standardMapUtils) {
        this.refinements = new ArrayList<RefinementDescription>();
        for (Refinement refinement : this.declaration.getRefinements()) {
            if (refinement instanceof BlockRefinement) {
                this.refinements.add(new BlockRefinementDescription((BlockRefinement)refinement, standardMapUtils));
                continue;
            }
            if (!(refinement instanceof FieldRefinement)) continue;
            this.refinements.add(new FieldRefinementDescription((FieldRefinement)refinement, standardMapUtils));
        }
    }
}

