/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne;

import fr.cnav.saturne.Block;
import fr.cnav.saturne.DataType;
import fr.cnav.saturne.DataTypeSet;
import fr.cnav.saturne.Declaration;
import fr.cnav.saturne.EnumDataType;
import fr.cnav.saturne.Field;
import fr.cnav.saturne.GenericRule;
import fr.cnav.saturne.HeaderBlock;
import fr.cnav.saturne.Message;
import fr.cnav.saturne.NamedElement;
import fr.cnav.saturne.ReusedBlock;
import fr.cnav.saturne.ReusedBlockSet;
import fr.cnav.saturne.RuleSet;
import fr.cnav.saturne.Standard;
import fr.cnav.saturne.Value;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class ModelAccessor {
    protected Standard standard;
    private Map<String, Block> fullQualifiedIdToBlock;
    private Map<String, Field> fullQualifiedIdToField;
    private final Map<String, Declaration> indexOfDeclarationsByName;
    private Map<String, DataType> idToDataTypes;
    private final Map<String, Value> indexOfQualifiedIdToEnumDataTypeValue;
    private Map<String, GenericRule> fullIdToRules;
    private Logger logger;
    private Map<Declaration, Set<Block>> declarationToBlockRefinement;
    private Map<Declaration, Set<Field>> declarationToFieldRefinement;

    public ModelAccessor(Standard theStandard) {
        this(theStandard, Logger.getAnonymousLogger());
    }

    public ModelAccessor(Standard theStandard, Logger logger) {
        if (theStandard == null) {
            throw new IllegalArgumentException("Standard must not be null.");
        }
        this.logger = logger == null ? Logger.getAnonymousLogger() : logger;
        this.declarationToBlockRefinement = new HashMap<Declaration, Set<Block>>();
        this.declarationToFieldRefinement = new HashMap<Declaration, Set<Field>>();
        this.fullQualifiedIdToBlock = new HashMap<String, Block>();
        this.fullQualifiedIdToField = new HashMap<String, Field>();
        this.idToDataTypes = new HashMap<String, DataType>();
        this.fullIdToRules = new HashMap<String, GenericRule>();
        this.standard = theStandard;
        if (theStandard.getMessage() != null) {
            HeaderBlock headerBlock = theStandard.getMessage().getHeaderBlock();
            this.initMaps(headerBlock);
            Block footerBlock = theStandard.getMessage().getFooterBlock();
            this.initMaps(footerBlock);
            this.initMaps(theStandard.getReusedBlocks());
            this.createDataTypesMap();
            this.createRulesMap();
        }
        this.indexOfQualifiedIdToEnumDataTypeValue = ModelAccessor.createDataTypesValuesIndex(this.standard);
        this.indexOfDeclarationsByName = ModelAccessor.createDeclarationsIndex(this.standard);
        this.initializeDeclarationInformation(theStandard);
    }

    public Map<Declaration, Set<Block>> getDeclarationToRefinedBlocks() {
        return this.declarationToBlockRefinement;
    }

    public Map<Declaration, Set<Field>> getDeclarationToRefinedFields() {
        return this.declarationToFieldRefinement;
    }

    private void initializeDeclarationInformation(Standard theStandard) {
        for (Declaration decl : theStandard.getDeclarations()) {
            HashSet<Field> refinedFields = new HashSet<Field>();
            Set<Field> refinedFieldSet = decl.getFieldRefinements().keySet();
            for (Field field : refinedFieldSet) {
                refinedFields.add(field);
            }
            this.declarationToFieldRefinement.put(decl, refinedFields);
            HashSet<Block> refinedBlocks = new HashSet<Block>();
            Set<Block> refinedBlockSet = decl.getBlockRefinements().keySet();
            for (Block block : refinedBlockSet) {
                refinedBlocks.add(block);
            }
            this.declarationToBlockRefinement.put(decl, refinedBlocks);
        }
    }

    private void initMaps(Block block) {
        if (block == null) {
            return;
        }
        String fullQualifiedId = block.getFullQualifiedId();
        if (fullQualifiedId == null) {
            this.logger.warning("Couldn't compute fullQualifiedId for block" + block.getName());
        } else {
            this.fullQualifiedIdToBlock.put(fullQualifiedId, block);
        }
        for (Block child : block.getChildrenBlocks()) {
            this.initMaps(child);
        }
        for (Field field : block.getChildrenFields()) {
            String fieldQualifiedId = field.getFullQualifiedId();
            if (fieldQualifiedId == null) {
                this.logger.warning("Couldn't compute fullQualifiedId for field" + field.getName());
                continue;
            }
            this.fullQualifiedIdToField.put(fieldQualifiedId, field);
        }
    }

    private void initMaps(ReusedBlockSet reusedBlockSet) {
        if (reusedBlockSet != null) {
            for (ReusedBlock block : reusedBlockSet.getReusedBlocks()) {
                for (Field field : block.getFields()) {
                    String fieldQualifiedId = field.getFullQualifiedId();
                    if (fieldQualifiedId == null) {
                        this.logger.warning("Couldn't compute fullQualifiedId for field" + field.getName());
                        continue;
                    }
                    this.fullQualifiedIdToField.put(fieldQualifiedId, field);
                }
            }
        }
    }

    private void createDataTypesMap() {
        this.idToDataTypes = new HashMap<String, DataType>();
        DataTypeSet dataTypes = this.standard.getDataTypes();
        if (dataTypes != null) {
            for (DataType type : dataTypes.getDatatypes()) {
                String id = type.getId();
                if (id == null) continue;
                this.idToDataTypes.put(type.getId(), type);
            }
        }
    }

    private static Map<String, Value> createDataTypesValuesIndex(Standard standard) {
        Objects.requireNonNull(standard);
        HashMap<String, Value> dataTypesValuesIndex = new HashMap<String, Value>();
        DataTypeSet dataTypes = standard.getDataTypes();
        if (dataTypes != null) {
            dataTypes.getDatatypes().stream().filter(EnumDataType.class::isInstance).map(EnumDataType.class::cast).forEach(enumDataType -> {
                for (Value value : enumDataType.getValues()) {
                    dataTypesValuesIndex.put(value.getFullQualifiedId(), value);
                }
            });
        }
        return dataTypesValuesIndex;
    }

    private void createRulesMap() {
        this.fullIdToRules = new HashMap<String, GenericRule>();
        RuleSet rules = this.standard.getRules();
        if (rules != null) {
            for (GenericRule rule : rules.getRules()) {
                String id = rule.getFullId();
                if (id == null) continue;
                this.fullIdToRules.put(rule.getFullId(), rule);
            }
        }
    }

    public boolean doesIdCorrespondsToAStandardElement(String fullQualifiedId) {
        if (this.fullQualifiedIdToBlock.get(fullQualifiedId) != null) {
            return true;
        }
        return this.fullQualifiedIdToField.get(fullQualifiedId) != null;
    }

    private static Map<String, Declaration> createDeclarationsIndex(Standard standard) {
        return standard.getDeclarations().stream().collect(Collectors.toMap(NamedElement::getName, Function.identity(), (a1, a2) -> a1));
    }

    public Block getBlock(String fullQualifiedId) {
        return this.fullQualifiedIdToBlock.get(fullQualifiedId);
    }

    public Field getField(String fullQualifiedId) {
        return this.fullQualifiedIdToField.get(fullQualifiedId);
    }

    public GenericRule getRule(String fullId) {
        return this.fullIdToRules.get(fullId);
    }

    public DataType getDataType(String id) {
        return this.idToDataTypes.get(id);
    }

    public Value getEnumDataTypeValue(String fullyQualifiedId) {
        Objects.requireNonNull(fullyQualifiedId);
        return this.indexOfQualifiedIdToEnumDataTypeValue.get(fullyQualifiedId);
    }

    public Message getMessage() {
        return this.standard.getMessage();
    }

    public Standard getStandard() {
        return this.standard;
    }

    public Declaration getDeclarationByName(String declarationName) {
        Objects.requireNonNull(declarationName);
        return this.indexOfDeclarationsByName.get(declarationName);
    }

    public int getNumberOfDeclarations() {
        return this.indexOfDeclarationsByName.size();
    }

    public void updateMaps(String id, NamedElement element) {
        if (element instanceof Block) {
            this.fullQualifiedIdToBlock.put(id, (Block)element);
        } else if (element instanceof Field) {
            this.fullQualifiedIdToField.put(id, (Field)element);
        } else if (element instanceof GenericRule) {
            this.fullIdToRules.put(id, (GenericRule)element);
        } else if (element instanceof DataType) {
            this.idToDataTypes.put(id, (DataType)element);
        } else if (element instanceof Value) {
            this.indexOfQualifiedIdToEnumDataTypeValue.put(id, (Value)element);
        } else if (element instanceof Declaration) {
            Declaration declaration = (Declaration)element;
            this.indexOfDeclarationsByName.put(id, declaration);
            this.declarationToBlockRefinement.put(declaration, declaration.getBlockRefinements().keySet());
            this.declarationToFieldRefinement.put(declaration, declaration.getFieldRefinements().keySet());
        }
    }
}

