/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.utils;

import fr.cnav.saturne.Block;
import fr.cnav.saturne.Field;
import fr.cnav.saturne.Standard;
import fr.cnav.saturne.utils.StandardUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;

public class FieldsBlocksCacheUtils {
    private List<Field> fields;
    private List<Block> blocks;
    private StandardUtil standardUtil = new StandardUtil();
    private Standard currentStandard;
    private EContentAdapter fieldBlockEContentAdapter = new EContentAdapter(){

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            if (notification.getEventType() != 9) {
                FieldsBlocksCacheUtils.this.updateCache(notification);
            }
        }
    };

    public List<Field> getFields(EObject element) {
        this.fillFieldsAndBlocksIfNeed(element);
        return this.fields;
    }

    public List<Block> getBlocks(EObject element) {
        this.fillFieldsAndBlocksIfNeed(element);
        return this.blocks;
    }

    public void razCache() {
        this.fields = null;
        this.blocks = null;
    }

    private void fillFieldsAndBlocksIfNeed(EObject element) {
        if (this.updateNeeded(element)) {
            this.fillFieldsAndBlocks(this.currentStandard);
        }
    }

    private void fillFieldsAndBlocks(Standard standard) {
        this.fields = new ArrayList<Field>();
        this.blocks = new ArrayList<Block>();
        if (standard != null && standard.getMessage() != null) {
            if (standard.getMessage().getHeaderBlock() != null) {
                this.fillFieldsAndBlocks(standard.getMessage().getHeaderBlock());
            }
            if (standard.getMessage().getFooterBlock() != null) {
                this.fillFieldsAndBlocks(standard.getMessage().getFooterBlock());
            }
        }
    }

    private void fillFieldsAndBlocks(Block block) {
        for (Field field : block.getChildrenFields()) {
            this.fields.add(field);
        }
        this.blocks.add(block);
        for (Block child : block.getChildrenBlocks()) {
            this.fillFieldsAndBlocks(child);
        }
    }

    private boolean updateNeeded(EObject element) {
        boolean newStd = this.adaptStandard(element);
        return newStd || this.fields == null || this.blocks == null;
    }

    private boolean adaptStandard(EObject element) {
        boolean result = false;
        Standard standard = this.standardUtil.getStandard(element);
        if (this.currentStandard == null || this.currentStandard != standard) {
            if (this.currentStandard != null && this.currentStandard.eAdapters().contains((Object)this.fieldBlockEContentAdapter)) {
                this.currentStandard.eAdapters().remove((Object)this.fieldBlockEContentAdapter);
            }
            this.currentStandard = standard;
        }
        if (standard != null && !standard.eAdapters().contains((Object)this.fieldBlockEContentAdapter)) {
            standard.eAdapters().add((Object)this.fieldBlockEContentAdapter);
            result = true;
        }
        return result;
    }

    private void updateCache(Notification notification) {
        if (this.fields == null || this.blocks == null) {
            return;
        }
        if (notification.getNotifier() instanceof Block) {
            if (notification.getEventType() == 3) {
                this.updateCacheBlockAdd(notification);
            } else if (notification.getEventType() == 4) {
                this.updateCacheBlockRemove(notification);
            }
        }
    }

    private void updateCacheBlockAdd(Notification notification) {
        if (notification.getFeatureID(Block.class) == 6) {
            if (notification.getNewValue() != null && notification.getNewValue() instanceof Field) {
                Field newField = (Field)notification.getNewValue();
                this.fields.add(newField);
            }
        } else if (notification.getFeatureID(Block.class) == 7 && notification.getNewValue() != null && notification.getNewValue() instanceof Block) {
            Block newBlock = (Block)notification.getNewValue();
            this.blocks.add(newBlock);
        }
    }

    private void updateCacheBlockRemove(Notification notification) {
        if (notification.getFeatureID(Block.class) == 6) {
            if (notification.getOldValue() instanceof Field) {
                Field oldField = (Field)notification.getOldValue();
                this.fields.remove(oldField);
            }
        } else if (notification.getFeatureID(Block.class) == 7 && notification.getOldValue() instanceof Block) {
            Block oldBlock = (Block)notification.getOldValue();
            this.blocks.remove(oldBlock);
        }
    }
}

