/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.utils;

import fr.cnav.saturne.Block;
import fr.cnav.saturne.DataType;
import fr.cnav.saturne.Declaration;
import fr.cnav.saturne.Field;
import fr.cnav.saturne.Message;
import fr.cnav.saturne.Standard;
import fr.cnav.saturne.UsageType;
import fr.cnav.saturne.utils.StandardUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;

public class FieldUtil {
    private Map<DataType, List<Field>> mapDataTypeToFields;
    private List<DataType> dataTypeNoUsed;

    public List<Field> getFields(DataType dataType) {
        List<Field> result = Collections.emptyList();
        if (dataType != null) {
            List<Field> listFields;
            StandardUtil standardUtil = new StandardUtil();
            Standard std = standardUtil.getStandard(dataType);
            if (this.mapDataTypeToFields == null || this.dataTypeNoUsed == null) {
                this.initFieldsCache(std);
            }
            if ((listFields = this.mapDataTypeToFields.get(dataType)) != null) {
                result = listFields;
            }
        }
        return result;
    }

    public List<DataType> getDataTypeNoUsed(Standard standard) {
        if (this.dataTypeNoUsed == null) {
            this.initFieldsCache(standard);
        }
        return this.dataTypeNoUsed;
    }

    public void reset() {
        this.dataTypeNoUsed = null;
        this.mapDataTypeToFields = null;
    }

    public boolean isFieldDescendantOfForbiddenBlock(Field field, Declaration declaration) {
        boolean isFromAForbiddenParent = false;
        if (field != null && declaration != null) {
            Block parentBloc = (Block)field.eContainer();
            while (!isFromAForbiddenParent) {
                if (parentBloc == null || parentBloc.eContainer() instanceof Message) break;
                if (declaration.getUsage(parentBloc) == UsageType.FORBIDDEN) {
                    isFromAForbiddenParent = true;
                }
                parentBloc = (Block)parentBloc.eContainer();
            }
        }
        return isFromAForbiddenParent;
    }

    private void initFieldsCache(Standard standard) {
        this.mapDataTypeToFields = new HashMap<DataType, List<Field>>();
        if (standard.getMessage() != null) {
            TreeIterator treeIterator = standard.getMessage().eAllContents();
            while (treeIterator.hasNext()) {
                EObject eObject = (EObject)treeIterator.next();
                if (!(eObject instanceof Field)) continue;
                this.setDataTypeMap((Field)eObject);
            }
        }
        this.dataTypeNoUsed = new ArrayList<DataType>();
        for (DataType dataType : standard.getDataTypes().getDatatypes()) {
            if (this.mapDataTypeToFields.containsKey(dataType)) continue;
            this.dataTypeNoUsed.add(dataType);
        }
    }

    private void setDataTypeMap(Field field) {
        DataType dataType = field.getDataType();
        if (dataType != null) {
            if (!this.mapDataTypeToFields.containsKey(dataType)) {
                this.mapDataTypeToFields.put(dataType, new ArrayList());
            }
            List<Field> fields = this.mapDataTypeToFields.get(dataType);
            fields.add(field);
        }
    }

    public int indexOfField(Field field) {
        EObject eContainer = field.eContainer();
        int index = -1;
        if (eContainer != null && eContainer instanceof Block) {
            index = ((Block)eContainer).getChildrenFields().indexOf((Object)field);
        }
        return index;
    }
}

