/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.dsl.types.adapter;

import fr.cnav.saturne.dsl.formules.Call;
import fr.cnav.saturne.dsl.formules.FunctionCall;
import fr.cnav.saturne.dsl.parser.Logging;
import fr.cnav.saturne.dsl.types.Type;
import fr.cnav.saturne.dsl.types.adapter.DSLTypeAdapter;
import fr.cnav.saturne.dsl.types.adapter.DSLTypeAdapterFactory;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.emf.ecore.EObject;

public class CallTypeAdapter
extends DSLTypeAdapter {
    private static final String IN_CALL_TO = " in call to ";

    public static Type getType(String typeName) {
        Type result = "bool".equals(typeName) ? Type.BOOLEAN : ("num".equals(typeName) ? Type.NUM : ("num_list".equals(typeName) ? Type.NUM_LIST : ("alphanum".equals(typeName) ? Type.ALPHANUM : ("alphanum_list".equals(typeName) ? Type.ALPHANUM_LIST : ("date".equals(typeName) ? Type.DATE : ("date_list".equals(typeName) ? Type.DATE_LIST : ("node".equals(typeName) ? Type.NODE : ("node_list".equals(typeName) ? Type.NODE_LIST : ("token".equals(typeName) ? Type.TOKEN : ("token_list".equals(typeName) ? Type.TOKEN_LIST : Type.UNDEFINED))))))))));
        return result;
    }

    private static String resultType(String signature) {
        int idx = signature.indexOf(58);
        if (idx < 0) {
            return "";
        }
        return signature.substring(idx + 1, signature.length());
    }

    public static Type resultTypes(String signature) {
        return CallTypeAdapter.getType(CallTypeAdapter.resultType(signature));
    }

    public static Type[] arguments(String signature) {
        Type[] result = null;
        int idx = signature.indexOf(58);
        if (idx < 0) {
            return null;
        }
        String args = signature.substring(0, idx);
        String[] argTypes = args.split(",");
        if (argTypes.length == 1 && "".equals(argTypes[0])) {
            result = new Type[]{};
        } else {
            result = new Type[argTypes.length];
            int i = 0;
            while (i < result.length) {
                result[i] = CallTypeAdapter.getType(argTypes[i]);
                ++i;
            }
        }
        return result;
    }

    boolean checkArguments(Call target, Type[] arguments, Map<String, Type> env) {
        FunctionCall fc = (FunctionCall)this.getTarget();
        String name = fc.getName();
        boolean result = true;
        if (arguments.length < target.getArguments().size()) {
            result = false;
            this.setErrorMsg("Extra argument to function call in call to " + name);
        } else if (arguments.length > target.getArguments().size()) {
            result = false;
            this.setErrorMsg("Missing argument to function call in call to " + name);
        } else {
            int argCount = arguments.length;
            int i = 0;
            while (i < argCount) {
                Type expectedType = arguments[i];
                if (expectedType == Type.UNDEFINED) {
                    this.setErrorMsg("Unknwon type found in function signature:  in call to " + name);
                    result = false;
                    break;
                }
                DSLTypeAdapter adapter = DSLTypeAdapterFactory.adapt((EObject)target.getArguments().get(i));
                Type argType = adapter.getType(expectedType, env);
                if (argType == Type.UNDEFINED) {
                    this.setErrorMsg(adapter.getErrorMsg());
                    result = false;
                    break;
                }
                if (!argType.compatibleType(expectedType)) {
                    result = false;
                    this.setErrorMsg("Function call argument has incompatible type:  at " + i + " : " + (Object)((Object)argType) + " instead of " + (Object)((Object)expectedType) + " in " + name);
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    @Override
    Type computeType(Type context, Map<String, Type> env) {
        Type result = null;
        assert (this.getTarget() instanceof FunctionCall);
        FunctionCall target = (FunctionCall)this.getTarget();
        String name = target.getName();
        int argcount = target.getArguments().size();
        String signature = this.getTypingEnvironement().getSignature(name, argcount);
        if (signature == null || "".equals(signature)) {
            this.setErrorMsg("Could not find a signature for function : " + name + "/" + argcount);
            result = Type.UNDEFINED;
        } else if (this.checkArguments(target, CallTypeAdapter.arguments(signature), env)) {
            String returnType = CallTypeAdapter.resultType(signature);
            result = CallTypeAdapter.getType(returnType);
            if (result == Type.UNDEFINED) {
                this.setErrorMsg("Unknwon type found in function signature: " + returnType);
            }
        } else {
            result = Type.UNDEFINED;
        }
        if (result == Type.UNDEFINED) {
            Logging.LOGGER.log(Level.SEVERE, this.getErrorMsg());
        }
        return result;
    }
}

