/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.dsl.optimization.vn;

import fr.cnav.saturne.dsl.formules.Binding;
import fr.cnav.saturne.dsl.formules.Expression;
import fr.cnav.saturne.dsl.formules.FieldRef;
import fr.cnav.saturne.dsl.formules.FormulesGenerator;
import fr.cnav.saturne.dsl.formules.Let;
import fr.cnav.saturne.dsl.formules.Literal;
import fr.cnav.saturne.dsl.formules.ValueList;
import fr.cnav.saturne.dsl.formules.VarRef;
import fr.cnav.saturne.dsl.optimization.FreshVariableGenerator;
import fr.cnav.saturne.dsl.optimization.Transformation;
import fr.cnav.saturne.dsl.optimization.TransformationUtils;
import fr.cnav.saturne.dsl.optimization.vn.EquivalentExpr;
import fr.cnav.saturne.dsl.optimization.vn.HashedExpression;
import fr.cnav.saturne.dsl.optimization.vn.ValueNumberingUtils;
import fr.cnav.saturne.dsl.optimization.vn.VariableUnifier;
import fr.cnav.saturne.dsl.types.Type;
import fr.cnav.saturne.dsl.types.adapter.DSLTypeAdapterFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;

public class ValueNumbering
extends FormulesGenerator
implements Transformation {
    private List<List<Expression>> values = new ArrayList<List<Expression>>();
    private Map<String, List<Integer>> hashedIndex = new HashMap<String, List<Integer>>();

    protected void analyze(EObject e) {
        for (EObject eObject : e.eContents()) {
            boolean newValue = false;
            if (eObject instanceof Expression) {
                Expression expr = (Expression)eObject;
                newValue = this.findValue(expr);
            }
            if (!newValue) continue;
            this.analyze(eObject);
        }
    }

    private void addExpression(Expression e, int i) {
        List<Expression> equivalentClass;
        if (i < this.values.size()) {
            equivalentClass = this.values.get(i);
            assert (equivalentClass != null);
        } else {
            assert (i == this.values.size());
            equivalentClass = new ArrayList<Expression>();
            this.values.add(equivalentClass);
        }
        equivalentClass.add(e);
    }

    protected boolean findValue(Expression e) {
        HashedExpression he = new HashedExpression(e);
        EquivalentExpr tester = new EquivalentExpr();
        List<Integer> candidates = this.hashedIndex.get(he.toString());
        if (candidates == null) {
            candidates = new ArrayList<Integer>();
            this.hashedIndex.put(he.toString(), candidates);
        }
        for (int num : candidates) {
            if (!tester.equivalent(e, this.values.get(num).get(0))) continue;
            this.addExpression(e, num);
            return false;
        }
        int result = this.values.size();
        this.addExpression(e, result);
        candidates.add(result);
        return true;
    }

    private boolean shareable(Expression e) {
        if (e instanceof FieldRef) {
            return DSLTypeAdapterFactory.adapt(e).getType() != Type.NODE;
        }
        return !(e instanceof Literal) && !(e instanceof VarRef) && !(e instanceof ValueList);
    }

    @Override
    public Expression transform(Expression inExpr) {
        Expression input = new VariableUnifier().transform(inExpr);
        HashMap<String, ValueMemo> representatives = new HashMap<String, ValueMemo>();
        HashSet<VarRef> references = new HashSet<VarRef>();
        this.analyze(input);
        int valueSize = this.values.size();
        int i = valueSize - 1;
        while (i >= 0) {
            List<Expression> value = this.values.get(i);
            Expression representative = value.get(0);
            if (value.size() > 1 && this.shareable(representative)) {
                Let topLevel = ValueNumberingUtils.topLevel(representative);
                String variable = FreshVariableGenerator.getFreshVariable();
                ValueMemo memo = new ValueMemo(variable, i, representative, topLevel);
                representatives.put(variable, memo);
            }
            --i;
        }
        for (Map.Entry entry : representatives.entrySet()) {
            ValueMemo memo = (ValueMemo)entry.getValue();
            int i2 = memo.rank;
            List<Expression> value = this.values.get(i2);
            for (Expression expr : value) {
                VarRef varRef = this.varRef((String)entry.getKey());
                references.add(varRef);
                TransformationUtils.substitute(expr, varRef);
            }
        }
        this.processBindings(representatives, references);
        EObject topContainer = input.eContainer();
        if (topContainer != null) {
            assert (topContainer instanceof Let);
            return (Let)topContainer;
        }
        return input;
    }

    private void processBindings(Map<String, ValueMemo> representatives, Set<VarRef> references) {
        List<ValueMemo> memos = this.topoSortedMemos(representatives, references);
        for (ValueMemo memo : memos) {
            Binding binding = this.binding(memo.varref, memo.value);
            memo.topLevel.getBindings().add((Object)binding);
        }
    }

    private List<String> dependencies(Expression value, Set<VarRef> refs) {
        TreeIterator iterator = value.eAllContents();
        ArrayList<String> result = new ArrayList<String>();
        while (iterator.hasNext()) {
            EObject eObject = (EObject)iterator.next();
            if (!(eObject instanceof VarRef) || !refs.contains(eObject)) continue;
            VarRef varref = (VarRef)eObject;
            result.add(varref.getVarName());
        }
        return result;
    }

    private List<ValueMemo> topoSortedMemos(Map<String, ValueMemo> memoMap, Set<VarRef> references) {
        HashMap<String, List<String>> dependencies = new HashMap<String, List<String>>();
        ArrayList<String> varsNotBound = new ArrayList<String>();
        ArrayList<ValueMemo> topoSortedValues = new ArrayList<ValueMemo>();
        HashSet<String> processedVar = new HashSet<String>();
        for (Map.Entry<String, ValueMemo> entry : memoMap.entrySet()) {
            ValueMemo memo = entry.getValue();
            varsNotBound.add(entry.getKey());
            dependencies.put(entry.getKey(), this.dependencies(memo.value, references));
        }
        while (!varsNotBound.isEmpty()) {
            ListIterator iterator = varsNotBound.listIterator();
            while (iterator.hasNext()) {
                String var = (String)iterator.next();
                List deps = (List)dependencies.get(var);
                if (!this.depsSatisfied(deps, processedVar)) continue;
                topoSortedValues.add(memoMap.get(var));
                iterator.remove();
                processedVar.add(var);
            }
        }
        return topoSortedValues;
    }

    private boolean depsSatisfied(List<String> deps, Set<String> processedVar) {
        for (String dep : deps) {
            if (processedVar.contains(dep)) continue;
            return false;
        }
        return true;
    }

    static class ValueMemo {
        String varref;
        Expression value;
        Let topLevel;
        int rank;

        ValueMemo(String var, int i, Expression val, Let let) {
            this.varref = var;
            this.rank = i;
            this.value = val;
            this.topLevel = let;
        }
    }
}

