/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.dsl.ast.validator;

import fr.cnav.saturne.dsl.ast.validator.ModelValidationFailedException;
import fr.cnav.saturne.dsl.formules.Binding;
import fr.cnav.saturne.dsl.formules.Date;
import fr.cnav.saturne.dsl.formules.Expression;
import fr.cnav.saturne.dsl.formules.IteratorVariable;
import fr.cnav.saturne.dsl.formules.Let;
import fr.cnav.saturne.dsl.formules.Quantified;
import fr.cnav.saturne.dsl.formules.VarRef;
import fr.cnav.saturne.dsl.parser.IParserConfiguration;
import fr.cnav.saturne.dsl.types.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.function.Predicate;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;

public class ModelValidator {
    private static final int DATE_LENGTH = 8;
    private static final String VARIABLE_ERROR_MSG = "The variable %s  isn't unique in current control";
    private static final String ROOT = "root";
    private static final String RUB = "rub";
    private IParserConfiguration configuration;
    private String dateValue;

    public ModelValidator(IParserConfiguration configuration) {
        this.configuration = configuration;
    }

    public void validate(EObject eObject) throws ModelValidationFailedException {
        this.validateAllVariablesDeclared(eObject);
        this.validateNoExpliciteVariablesDeclared(eObject);
        this.validateDateLiterals((Expression)eObject);
        if (eObject instanceof Quantified) {
            Quantified quantified = (Quantified)eObject;
            this.validateUniqueVariableNamesQualifier(quantified);
        } else if (eObject instanceof Let) {
            Let let = (Let)eObject;
            this.validateUniqueVariableNamesLet(let);
        }
        TreeIterator treeIterator = eObject.eAllContents();
        while (treeIterator.hasNext()) {
            EObject curEObj = (EObject)treeIterator.next();
            if (curEObj instanceof Quantified) {
                Quantified quantified = (Quantified)curEObj;
                this.validateUniqueVariableNamesQualifier(quantified);
                continue;
            }
            if (!(curEObj instanceof Let)) continue;
            Let let = (Let)curEObj;
            this.validateUniqueVariableNamesLet(let);
        }
    }

    private void validateUniqueVariableNamesQualifier(Quantified quantified) throws ModelValidationFailedException {
        ArrayList<String> varNameList = new ArrayList<String>();
        for (IteratorVariable iteratorVariable : quantified.getVariables()) {
            if (varNameList.contains(iteratorVariable.getVarName())) {
                throw new ModelValidationFailedException(this.getVariableErrorMsg(iteratorVariable.getVarName()));
            }
            varNameList.add(iteratorVariable.getVarName());
        }
        TreeIterator treeIterator = quantified.getExpression().eAllContents();
        while (treeIterator.hasNext()) {
            Binding binding;
            EObject curEObj = (EObject)treeIterator.next();
            if (curEObj instanceof IteratorVariable) {
                IteratorVariable iteratorVariable = (IteratorVariable)curEObj;
                if (!varNameList.contains(iteratorVariable.getVarName())) continue;
                throw new ModelValidationFailedException(this.getVariableErrorMsg(iteratorVariable.getVarName()));
            }
            if (!(curEObj instanceof Binding) || !varNameList.contains((binding = (Binding)curEObj).getVarName())) continue;
            throw new ModelValidationFailedException(this.getVariableErrorMsg(binding.getVarName()));
        }
    }

    private void validateUniqueVariableNamesLet(Let let) throws ModelValidationFailedException {
        ArrayList<String> varNameList = new ArrayList<String>();
        for (Binding binding : let.getBindings()) {
            if (varNameList.contains(binding.getVarName())) {
                throw new ModelValidationFailedException(this.getVariableErrorMsg(binding.getVarName()));
            }
            varNameList.add(binding.getVarName());
        }
        TreeIterator treeIterator = let.getIn().eAllContents();
        while (treeIterator.hasNext()) {
            Binding binding;
            EObject curEObj = (EObject)treeIterator.next();
            if (curEObj instanceof IteratorVariable) {
                IteratorVariable iteratorVariable = (IteratorVariable)curEObj;
                if (!varNameList.contains(iteratorVariable.getVarName())) continue;
                throw new ModelValidationFailedException(VARIABLE_ERROR_MSG + iteratorVariable.getVarName() + " isn't unique in current control");
            }
            if (!(curEObj instanceof Binding) || !varNameList.contains((binding = (Binding)curEObj).getVarName())) continue;
            throw new ModelValidationFailedException(VARIABLE_ERROR_MSG + binding.getVarName() + " isn't unique in current control");
        }
    }

    private void validateNoExpliciteVariablesDeclared(EObject eObject) throws ModelValidationFailedException {
        TreeIterator treeIterator = eObject.eAllContents();
        while (treeIterator.hasNext()) {
            Binding binding;
            IteratorVariable variable;
            String varName;
            EObject curEObj = (EObject)treeIterator.next();
            if (!(curEObj instanceof IteratorVariable ? ROOT.equals(varName = (variable = (IteratorVariable)curEObj).getVarName()) || RUB.equals(varName) : curEObj instanceof Binding && (ROOT.equals(varName = (binding = (Binding)curEObj).getVarName()) || RUB.equals(varName)))) continue;
            throw new ModelValidationFailedException("It's not allowed to use implicite variable " + varName + ".");
        }
    }

    private void validateAllVariablesDeclared(EObject eObject) throws ModelValidationFailedException {
        TreeIterator treeIterator = eObject.eAllContents();
        while (treeIterator.hasNext()) {
            EObject curEObj = (EObject)treeIterator.next();
            if (!(curEObj instanceof VarRef)) continue;
            VarRef varRef = (VarRef)curEObj;
            String varName = varRef.getVarName();
            if (varName.equals(ROOT) || varName.equals(RUB) || this.configuration.getType(varName) != null && !this.configuration.getType(varName).equals((Object)Type.UNDEFINED)) {
                return;
            }
            this.searchDeclarrationInContener(varRef, varName);
        }
    }

    private void searchDeclarrationInContener(EObject eObject, String varRefName) throws ModelValidationFailedException {
        if (eObject instanceof Quantified) {
            Quantified quantified = (Quantified)eObject;
            for (IteratorVariable iteratorVariable : quantified.getVariables()) {
                if (!iteratorVariable.getVarName().equals(varRefName)) continue;
                return;
            }
        } else if (eObject instanceof Let) {
            Let let = (Let)eObject;
            for (Binding binding : let.getBindings()) {
                if (!binding.getVarName().equals(varRefName)) continue;
                return;
            }
        }
        if (eObject.eContainer() == null) {
            throw new ModelValidationFailedException(this.getVariableErrorMsg(varRefName));
        }
        this.searchDeclarrationInContener(eObject.eContainer(), varRefName);
    }

    private void validateDateLiterals(Expression expr) throws ModelValidationFailedException {
        boolean valid;
        TreeIterator iterator = expr.eAllContents();
        ArrayList<Date> dates = new ArrayList<Date>();
        while (iterator.hasNext()) {
            EObject eObject = (EObject)iterator.next();
            if (!(eObject instanceof Date)) continue;
            dates.add((Date)eObject);
        }
        if (expr instanceof Date) {
            dates.add((Date)expr);
        }
        if (!(valid = dates.stream().allMatch(new Predicate<EObject>(){

            @Override
            public boolean test(EObject arg0) {
                boolean result;
                if (arg0 instanceof Date) {
                    Date date = (Date)arg0;
                    SimpleDateFormat sdf = new SimpleDateFormat("ddMMyyyy");
                    sdf.setLenient(false);
                    try {
                        sdf.parse(date.getValue().substring(0, 8));
                        result = true;
                    }
                    catch (ParseException parseException) {
                        ModelValidator.this.dateValue = date.getValue();
                        result = false;
                    }
                } else {
                    result = true;
                }
                return result;
            }
        }))) {
            throw new ModelValidationFailedException("Date invalide dans un contr\u00f4le : " + this.dateValue);
        }
    }

    private String getVariableErrorMsg(String var) {
        return "The variable " + var + " isn't unique in current control or doesn't exist.";
    }
}

