/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.dsl.ast.validator;

import fr.cnav.saturne.dsl.formules.Expression;
import fr.cnav.saturne.dsl.formules.FieldRef;
import fr.cnav.saturne.dsl.formules.FunctionCall;
import fr.cnav.saturne.dsl.formules.IteratorVariable;
import fr.cnav.saturne.dsl.formules.Quantified;
import fr.cnav.saturne.dsl.gen.common.navigation.IMessage;
import fr.cnav.saturne.dsl.gen.common.navigation.IMessageNode;
import fr.cnav.saturne.dsl.parser.IParserConfiguration;
import org.eclipse.emf.ecore.EObject;

public class CardinalityValidator {
    private IMessage message;
    private IParserConfiguration parserConfiguration;

    public CardinalityValidator(IParserConfiguration parserConfiguration, IMessage message) {
        this.message = message;
        this.parserConfiguration = parserConfiguration;
    }

    private boolean isMultiple(IMessageNode context, IMessageNode target) {
        int i;
        boolean result = false;
        IMessageNode currentContext = context;
        IMessageNode currentTarget = target;
        int contextDepth = context.getDepth();
        int targetDepth = currentTarget.getDepth();
        String targetName = currentTarget.getName();
        if (contextDepth > targetDepth) {
            int depthDiff = contextDepth - targetDepth;
            i = 0;
            while (i < depthDiff) {
                if (currentContext == null) {
                    throw new IllegalStateException("Couldn't navigate from empty context to " + targetName);
                }
                currentContext = currentContext.getParent();
                ++i;
            }
        } else if (contextDepth < targetDepth) {
            int depthDiff = targetDepth - contextDepth;
            i = 0;
            while (i < depthDiff) {
                if (currentTarget == null) {
                    throw new IllegalStateException("Couldn't navigate from " + currentContext.getName());
                }
                IMessageNode child = currentTarget;
                currentTarget = currentTarget.getParent();
                if (child.isMany()) {
                    result = true;
                }
                ++i;
            }
        }
        while (!result && !currentTarget.equals(currentContext)) {
            IMessageNode child = currentTarget;
            currentTarget = currentTarget.getParent();
            currentContext = currentContext.getParent();
            if (currentTarget == null || currentContext == null) {
                throw new IllegalStateException("structure doesn't seem to be active : " + targetName);
            }
            if (!child.isMany()) continue;
            result = true;
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private boolean isQuantified(FieldRef fieldRef) {
        block4: {
            block3: {
                container = fieldRef.eContainer();
                result = false;
                if (!(container instanceof IteratorVariable)) break block3;
                result = true;
                break block4;
            }
            var = fieldRef.getContextVariable();
            if (var != null) ** GOTO lbl16
            throw new IllegalStateException("Context variable should never be null. Use the default 'root' variable.");
lbl-1000:
            // 1 sources

            {
                if (container instanceof Quantified) {
                    for (IteratorVariable varDef : ((Quantified)container).getVariables()) {
                        if (!var.equals(varDef.getVarName())) continue;
                        result = true;
                    }
                }
                container = container.eContainer();
lbl16:
                // 2 sources

                ** while (!result && container != null)
            }
lbl17:
            // 1 sources

            result = false;
        }
        return result;
    }

    private boolean argFunIsANodeType(FieldRef fieldRef) {
        EObject container = fieldRef.eContainer();
        boolean result = false;
        if (container instanceof FunctionCall) {
            result = this.checkSignatureParameterType(fieldRef, (FunctionCall)container);
        }
        return result;
    }

    private boolean checkSignatureParameterType(FieldRef fieldRef, FunctionCall function) {
        boolean result = false;
        String signature = this.parserConfiguration.getDefinition(String.valueOf(function.getName()) + "/" + function.getArguments().size() + ".prototype");
        if (signature != null && !signature.isEmpty()) {
            String argTypeString = signature.split(":")[0];
            String[] argTypeList = argTypeString.split(",");
            int i = 0;
            for (Expression variable : function.getArguments()) {
                if (variable == fieldRef) {
                    String variableType = argTypeList[i];
                    result = "node".equals(variableType);
                }
                ++i;
            }
        }
        return result;
    }

    public boolean isValid(Expression expr, String context) {
        if (expr == null || context == null || context.isEmpty()) {
            return true;
        }
        if (expr instanceof FieldRef) {
            return this.isValidFieldRef((FieldRef)expr, context);
        }
        return true;
    }

    private boolean isValidFieldRef(FieldRef fieldRef, String context) {
        String fieldName = fieldRef.getName();
        IMessageNode contextNode = this.message.getMessageNode(context);
        IMessageNode targetNode = this.message.getMessageNode(fieldName);
        if (contextNode == null) {
            throw new IllegalStateException("structure " + context + " couldn't be found in the bundle.");
        }
        if (targetNode == null) {
            throw new IllegalStateException("structure " + fieldName + " couldn't be found in the bundle.");
        }
        boolean isMultiple = this.isMultiple(contextNode, targetNode);
        boolean isQuantified = this.isQuantified(fieldRef);
        boolean isFunVarNodeType = this.argFunIsANodeType(fieldRef);
        boolean isValid = true;
        if (isMultiple && isQuantified) {
            isValid = true;
        } else if (isMultiple && isFunVarNodeType) {
            isValid = true;
        } else if (isMultiple && !isFunVarNodeType && !isQuantified) {
            isValid = false;
        } else if (!isMultiple && isQuantified) {
            isValid = false;
        }
        return isValid;
    }
}

