/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.api.model.access;

import fr.cnav.saturne.api.model.access.BlockDescription;
import fr.cnav.saturne.api.model.access.DataTypeDescription;
import fr.cnav.saturne.api.model.access.FieldDescription;
import fr.cnav.saturne.api.model.access.GenericRuleDescription;
import fr.cnav.saturne.api.model.access.NamedElementDescription;
import java.util.HashMap;
import java.util.Map;

public class StandardMapUtils {
    private Map<String, BlockDescription> fullQualifiedIdToBlock = new HashMap<String, BlockDescription>();
    private Map<String, FieldDescription> fullQualifiedIdToField = new HashMap<String, FieldDescription>();
    private Map<String, DataTypeDescription> idToDataTypes = new HashMap<String, DataTypeDescription>();
    private Map<String, GenericRuleDescription> fullIdToRules = new HashMap<String, GenericRuleDescription>();

    public BlockDescription getBlockDescription(String fullQualifiedId) {
        return this.fullQualifiedIdToBlock.get(fullQualifiedId);
    }

    public FieldDescription getFieldDescription(String fullQualifiedId) {
        return this.fullQualifiedIdToField.get(fullQualifiedId);
    }

    public GenericRuleDescription getRuleDescription(String fullId) {
        return this.fullIdToRules.get(fullId);
    }

    public DataTypeDescription getDataTypeDescription(String id) {
        return this.idToDataTypes.get(id);
    }

    public void updateMaps(String id, NamedElementDescription element) {
        if (element instanceof BlockDescription) {
            this.fullQualifiedIdToBlock.put(id, (BlockDescription)element);
        } else if (element instanceof FieldDescription) {
            this.fullQualifiedIdToField.put(id, (FieldDescription)element);
        } else if (element instanceof GenericRuleDescription) {
            this.fullIdToRules.put(id, (GenericRuleDescription)element);
        } else if (element instanceof DataTypeDescription) {
            this.idToDataTypes.put(id, (DataTypeDescription)element);
        }
    }
}

