/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.api.model.access;

import fr.cnav.saturne.BlockContext;
import fr.cnav.saturne.FieldContext;
import fr.cnav.saturne.ReportConfiguration;
import fr.cnav.saturne.api.model.access.BlockContextDescription;
import fr.cnav.saturne.api.model.access.BlockDescription;
import fr.cnav.saturne.api.model.access.FieldContextDescription;
import fr.cnav.saturne.api.model.access.StandardMapUtils;
import java.util.ArrayList;
import java.util.List;

public class ReportConfigurationDescription {
    private ReportConfiguration reportConfiguration;
    private List<FieldContextDescription> fieldContexts;
    private List<BlockContextDescription> blockContexts;
    private BlockDescription block;

    public ReportConfigurationDescription(ReportConfiguration theReportConfiguration, StandardMapUtils standardMapUtils) {
        this.reportConfiguration = theReportConfiguration;
        this.fieldContexts = new ArrayList<FieldContextDescription>();
        for (FieldContext fieldContext : this.reportConfiguration.getFieldContexts()) {
            this.fieldContexts.add(new FieldContextDescription(fieldContext, standardMapUtils));
        }
        this.blockContexts = new ArrayList<BlockContextDescription>();
        for (BlockContext blockContext : this.reportConfiguration.getBlockContexts()) {
            this.blockContexts.add(new BlockContextDescription(blockContext, standardMapUtils));
        }
        if (this.reportConfiguration.getBlock() != null) {
            this.block = standardMapUtils.getBlockDescription(this.reportConfiguration.getBlock().getFullQualifiedId());
        }
    }

    public String getSerialisationHandler() {
        return this.reportConfiguration.getSerialisationHandler();
    }

    public List<FieldContextDescription> getFieldContexts() {
        return this.fieldContexts;
    }

    public List<BlockContextDescription> getBlockContexts() {
        return this.blockContexts;
    }

    public boolean isSerializeValidationId() {
        return this.reportConfiguration.isSerializeValidationId();
    }

    public boolean isSerializeValidationExecutionTime() {
        return this.reportConfiguration.isSerializeValidationExecutionTime();
    }

    public boolean isSerializeValidationComponentVersion() {
        return this.reportConfiguration.isSerializeValidationComponentVersion();
    }

    public BlockDescription getBlock() {
        return this.block;
    }

    public String getName() {
        return this.reportConfiguration.getName();
    }

    public boolean isStrictSelf() {
        return this.reportConfiguration.isStrictSelf();
    }

    public boolean isStrictSubContexts() {
        return this.reportConfiguration.isStrictSubContexts();
    }

    public boolean isUseAnomalyCounter() {
        return this.reportConfiguration.isUseAnomalyCounter();
    }

    public boolean isUseTotalAnomalyCounter() {
        return this.reportConfiguration.isUseTotalAnomalyCounter();
    }
}

