/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.api.model.access;

import fr.cnav.saturne.AlphanumericDataType;
import fr.cnav.saturne.DataType;
import fr.cnav.saturne.DataTypeSet;
import fr.cnav.saturne.DateDataType;
import fr.cnav.saturne.EnumDataType;
import fr.cnav.saturne.ExternalDataType;
import fr.cnav.saturne.NumericDataType;
import fr.cnav.saturne.api.model.access.AlphanumericDataTypeDescription;
import fr.cnav.saturne.api.model.access.DataTypeDescription;
import fr.cnav.saturne.api.model.access.DateDataTypeDescription;
import fr.cnav.saturne.api.model.access.EnumDataTypeDescription;
import fr.cnav.saturne.api.model.access.ExternalDataTypeDescription;
import fr.cnav.saturne.api.model.access.NumericDataTypeDescription;
import fr.cnav.saturne.api.model.access.StandardMapUtils;
import java.util.ArrayList;
import java.util.List;

public class DataTypeSetDescription {
    private List<DataTypeDescription> datatypes = new ArrayList<DataTypeDescription>();

    public DataTypeSetDescription(DataTypeSet theDataTypeSet, StandardMapUtils standardMapUtils) {
        for (DataType dataType : theDataTypeSet.getDatatypes()) {
            if (dataType instanceof AlphanumericDataType) {
                this.datatypes.add(new AlphanumericDataTypeDescription((AlphanumericDataType)dataType, standardMapUtils));
                continue;
            }
            if (dataType instanceof NumericDataType) {
                this.datatypes.add(new NumericDataTypeDescription((NumericDataType)dataType, standardMapUtils));
                continue;
            }
            if (dataType instanceof DateDataType) {
                this.datatypes.add(new DateDataTypeDescription((DateDataType)dataType, standardMapUtils));
                continue;
            }
            if (dataType instanceof ExternalDataType) {
                this.datatypes.add(new ExternalDataTypeDescription((ExternalDataType)dataType, standardMapUtils));
                continue;
            }
            if (!(dataType instanceof EnumDataType)) continue;
            this.datatypes.add(new EnumDataTypeDescription((EnumDataType)dataType, standardMapUtils));
        }
    }

    public List<DataTypeDescription> getDatatypes() {
        return this.datatypes;
    }
}

