/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.app.service.helpers;

import fr.cnav.saturne.app.service.exception.ExceptionKind;
import fr.cnav.saturne.app.service.exception.ValidationServiceException;
import fr.cnav.saturne.app.service.helpers.Messages;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;

public final class SystemFileHelper {
    private SystemFileHelper() {
    }

    public static File createTempDirAndInstallHookDeleteOnShutdown() {
        File tempDir = null;
        try {
            tempDir = File.createTempFile("temp", null);
            boolean resultat = tempDir.delete();
            if (!resultat) {
                throw new RuntimeException(String.format(Messages.LOG_RUNNING_18, tempDir.getAbsolutePath()));
            }
            resultat = tempDir.mkdir();
            if (!resultat) {
                throw new RuntimeException(String.format(Messages.LOG_RUNNING_19, tempDir.getAbsolutePath()));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return tempDir;
    }

    public static void deleteFolder(File fileToDelete) {
        try {
            boolean isDelete;
            SystemFileHelper.deleteRecursively(fileToDelete);
            File stateDir = new File("." + File.separatorChar + "state");
            if (stateDir.exists() && stateDir.isDirectory() && !(isDelete = stateDir.delete())) {
                throw new ValidationServiceException(ExceptionKind.ERASE_RESSOURCE_FAILED, stateDir.getAbsolutePath());
            }
        }
        catch (IOException e) {
            throw new ValidationServiceException(ExceptionKind.ERASE_RESSOURCE_FAILED, e.getMessage());
        }
    }

    private static void deleteRecursively(File file) throws IOException {
        if (file.isDirectory()) {
            SystemFileHelper.deleteDirectoryContents(file);
        }
        if (!file.delete()) {
            throw new IOException("Failed to delete " + file);
        }
    }

    private static void deleteDirectoryContents(File directory) throws IOException {
        if (!directory.isDirectory()) {
            return;
        }
        File[] files = directory.listFiles();
        if (files == null) {
            throw new IOException("Error listing files for " + directory);
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            SystemFileHelper.deleteRecursively(file);
            ++n2;
        }
    }

    public static File[] filterHiddenFiles(File sourceFile) {
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File arg0) {
                return !arg0.isHidden() && !arg0.getName().startsWith(".");
            }
        };
        if (sourceFile == null) {
            return null;
        }
        return sourceFile.listFiles(fileFilter);
    }
}

