/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.autocontrole.messageparser;

import fr.cnav.autocontrole.messageparser.IndividualInformationDescriptor;
import fr.cnav.saturne.api.model.access.DeclarationDescription;
import fr.cnav.saturne.api.model.access.StandardDescription;
import fr.cnav.saturne.report.model.Anomaly;
import fr.cnav.saturne.validator.autocontrol.registry.IIndividualFieldRegistry;
import fr.cnav.saturne.validator.conversion.xml.BlockDeclarationAnnotation;
import fr.cnav.saturne.validator.message.DeclarationMessageBlock;
import fr.cnav.saturne.validator.message.api.IDeclarationMessageBlock;
import fr.cnav.saturne.validator.message.api.IMessageBlock;
import fr.cnav.saturne.validator.message.api.IMessageField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MessageParserForIndividual {
    private final String individualContextClassFQId;
    private Map<Integer, String> declarationRankToDeclarationNature;
    private Integer declarationRank;
    private Integer index;
    private int nbIndividualBlocks;
    private Map<Integer, IndividualInformationDescriptor> fieldLineNumberToIndividualDescriptorMap;
    private IndividualInformationDescriptor currentIndividualDescriptor;
    private final List<String> individualFieldsFullQualifiedIdList;
    private final List<Anomaly> anomalies;
    private Map<String, DeclarationDescription> mapDeclaration;
    private DeclarationDescription currentDeclaration;

    public MessageParserForIndividual(IMessageBlock rootMessageBlock, String contextClassFQId, List<IIndividualFieldRegistry> individualFields, List<Anomaly> anomalies, StandardDescription standard) {
        if (anomalies == null) {
            throw new IllegalArgumentException(String.valueOf(this.getClass().getSimpleName()) + " : Some parameters must not be null.");
        }
        this.anomalies = anomalies;
        this.individualContextClassFQId = contextClassFQId;
        this.individualFieldsFullQualifiedIdList = new ArrayList<String>();
        this.declarationRankToDeclarationNature = new HashMap<Integer, String>();
        this.fieldLineNumberToIndividualDescriptorMap = new HashMap<Integer, IndividualInformationDescriptor>();
        this.nbIndividualBlocks = 0;
        this.declarationRank = 0;
        this.index = 0;
        if (individualFields != null) {
            for (IIndividualFieldRegistry iIndividualFieldRegistry : individualFields) {
                if (iIndividualFieldRegistry.getFirstRubiqueFullQualifiedId() != null) {
                    this.individualFieldsFullQualifiedIdList.add(iIndividualFieldRegistry.getFirstRubiqueFullQualifiedId());
                }
                if (iIndividualFieldRegistry.getSecondRubiqueFullQualifiedId() == null) continue;
                this.individualFieldsFullQualifiedIdList.add(iIndividualFieldRegistry.getSecondRubiqueFullQualifiedId());
            }
        }
        this.mapDeclaration = new HashMap<String, DeclarationDescription>();
        for (DeclarationDescription declaration : standard.getDeclarations()) {
            this.mapDeclaration.put(declaration.getName(), declaration);
        }
        this.handleAllIndividuals(rootMessageBlock);
        this.mapDeclaration.clear();
    }

    public int getNbIndividualBlocks() {
        return this.nbIndividualBlocks;
    }

    private void handleAllIndividuals(IMessageBlock messageBlock) {
        if (this.individualContextClassFQId.equals(messageBlock.getStandardBlockDescription().getFullQualifiedId())) {
            ++this.nbIndividualBlocks;
            this.currentIndividualDescriptor = new IndividualInformationDescriptor(this.currentDeclaration);
            this.currentIndividualDescriptor.setRankInDeclaration(this.declarationRank);
            this.currentIndividualDescriptor.setStartLine(messageBlock.getFirstLine());
            this.currentIndividualDescriptor.setBlock(messageBlock);
        }
        if (messageBlock instanceof IDeclarationMessageBlock) {
            this.index = this.index + 1;
            IDeclarationMessageBlock declarationMessageBlock = (IDeclarationMessageBlock)messageBlock;
            String name = this.getDeclarationName(declarationMessageBlock);
            this.currentDeclaration = this.mapDeclaration.get(name);
            this.declarationRankToDeclarationNature.put(this.index, name);
        }
        if (this.currentIndividualDescriptor != null) {
            int lastLineNumber = this.computeLastLineNumber(messageBlock);
            if (this.isIndividualConcernedByAnomaly(this.currentIndividualDescriptor.getStartLine(), lastLineNumber)) {
                List fields = messageBlock.getFields();
                for (IMessageField messageField : fields) {
                    this.fieldLineNumberToIndividualDescriptorMap.put(messageField.getFieldLocalizer().getLineNumber(), this.currentIndividualDescriptor);
                    if (!this.individualFieldsFullQualifiedIdList.contains(messageField.getStandardFieldDescription().getFullQualifiedId())) continue;
                    this.currentIndividualDescriptor.getFieldFullQualifiedIdToValueMap().put(messageField.getStandardFieldDescription().getFullQualifiedId(), messageField.getOriginalValueAsString());
                }
                List allChildren = messageBlock.getChildren();
                for (List children : allChildren) {
                    for (IMessageBlock messageBlockChild : children) {
                        this.handleAllIndividuals(messageBlockChild);
                    }
                }
            }
        } else {
            List allChildren = messageBlock.getChildren();
            for (List children : allChildren) {
                for (IMessageBlock messageBlockChild : children) {
                    this.handleAllIndividuals(messageBlockChild);
                }
            }
        }
        if (this.individualContextClassFQId.equals(messageBlock.getStandardBlockDescription().getFullQualifiedId())) {
            this.currentIndividualDescriptor = null;
        }
    }

    private String getDeclarationName(IDeclarationMessageBlock declarationMessageBlock) {
        String name = "";
        for (Object annotation : ((DeclarationMessageBlock)declarationMessageBlock).getAnnotations()) {
            if (!(annotation instanceof BlockDeclarationAnnotation)) continue;
            name = ((BlockDeclarationAnnotation)annotation).getDeclaration().getName();
        }
        return name;
    }

    private int computeLastLineNumber(IMessageBlock messageBlock) {
        int lastLineNumber = this.doComputeLastLineNumber(messageBlock);
        if (lastLineNumber == -1 && !messageBlock.getFields().isEmpty()) {
            lastLineNumber = ((IMessageField)messageBlock.getFields().get(messageBlock.getFields().size() - 1)).getFieldLocalizer().getLineNumber();
        }
        return lastLineNumber;
    }

    private int doComputeLastLineNumber(IMessageBlock messageBlock) {
        int lastLineNumber = -1;
        List children = messageBlock.getChildren();
        for (List list : children) {
            if (list == null || list.isEmpty()) continue;
            for (IMessageBlock messageBlockTemp : list) {
                int tempLineNumber;
                if (messageBlockTemp != null && !messageBlockTemp.getFields().isEmpty()) {
                    lastLineNumber = ((IMessageField)messageBlockTemp.getFields().get(messageBlockTemp.getFields().size() - 1)).getFieldLocalizer().getLineNumber();
                }
                if ((tempLineNumber = this.doComputeLastLineNumber(messageBlockTemp)) == -1) continue;
                lastLineNumber = tempLineNumber;
            }
        }
        return lastLineNumber;
    }

    private boolean isIndividualConcernedByAnomaly(int startLineNumber, int endLineNumber) {
        for (Anomaly anomaly : this.anomalies) {
            if (endLineNumber < anomaly.getFieldLocalizer().getLineNumber() || startLineNumber > anomaly.getFieldLocalizer().getLineNumber()) continue;
            return true;
        }
        return false;
    }

    public Map<Integer, IndividualInformationDescriptor> getFieldLineNumberToIndividualDescriptorMap() {
        return this.fieldLineNumberToIndividualDescriptorMap;
    }

    public Map<Integer, String> getRankDeclarationToDeclarationNatureMap() {
        return this.declarationRankToDeclarationNature;
    }
}

