/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.autocontrole.helpers;

import fr.cnav.autocontrole.exception.AutoCtrlException;
import fr.cnav.autocontrole.exception.ExceptionKind;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public final class ZipUtil {
    private static byte[] magic = new byte[]{80, 75, 3, 4};
    private static final int NBBYTE = 1024;

    private ZipUtil() {
    }

    public static boolean isZipFile(File f) {
        boolean isZip = true;
        byte[] buffer = new byte[magic.length];
        try {
            RandomAccessFile raf = new RandomAccessFile(f, "r");
            raf.readFully(buffer);
            int i = 0;
            while (i < magic.length) {
                if (buffer[i] != magic[i]) {
                    isZip = false;
                    break;
                }
                ++i;
            }
            raf.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            isZip = false;
        }
        catch (IOException iOException) {
            isZip = false;
        }
        return isZip;
    }

    public static InputStream getInputStream(ZipFile zf) {
        ZipEntry zipEntry = null;
        zipEntry = ZipUtil.getFirstEntrie(zf);
        InputStream result = null;
        if (zipEntry != null) {
            try {
                result = zf.getInputStream(zipEntry);
            }
            catch (IOException iOException) {
                result = null;
            }
        }
        return result;
    }

    private static ZipEntry getFirstEntrie(ZipFile zip) {
        ZipEntry firstEntrie = null;
        if (zip != null && zip.entries().hasMoreElements() && firstEntrie == null) {
            firstEntrie = zip.entries().nextElement();
        }
        return firstEntrie;
    }

    public static void extactFirstFile(File inputFile, File unzippedFile) {
        InputStream inputStream = null;
        FileOutputStream outputStream = null;
        try {
            try {
                ZipFile zipFile = new ZipFile(inputFile);
                inputStream = ZipUtil.getInputStream(zipFile);
                outputStream = new FileOutputStream(unzippedFile);
                int read = 0;
                byte[] bytes = new byte[1024];
                while ((read = inputStream.read(bytes)) != -1) {
                    outputStream.write(bytes, 0, read);
                }
            }
            catch (ZipException e) {
                throw new AutoCtrlException(ExceptionKind.ERROR_ZIP_FILE_ACCESS, inputFile.getAbsolutePath(), e.getMessage());
            }
            catch (IOException e) {
                throw new AutoCtrlException(ExceptionKind.ERROR_ZIP_FILE_ACCESS, inputFile.getAbsolutePath(), e.getMessage());
            }
        }
        catch (Throwable throwable) {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    throw new AutoCtrlException(ExceptionKind.CANNOT_CLOSE_ZIP_FILE, inputFile.getAbsolutePath(), e.getMessage());
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    throw new AutoCtrlException(ExceptionKind.CANNOT_CLOSE_FILE, unzippedFile.getAbsolutePath(), e.getMessage());
                }
            }
            throw throwable;
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                throw new AutoCtrlException(ExceptionKind.CANNOT_CLOSE_ZIP_FILE, inputFile.getAbsolutePath(), e.getMessage());
            }
        }
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                throw new AutoCtrlException(ExceptionKind.CANNOT_CLOSE_FILE, unzippedFile.getAbsolutePath(), e.getMessage());
            }
        }
    }
}

