/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.autocontrole.helpers;

import fr.cnav.autocontrole.messageparser.IndividualInformationDescriptor;
import fr.cnav.autocontrole.models.MessageFile;
import fr.cnav.saturne.api.model.access.DeclarationDescription;
import fr.cnav.saturne.report.model.Anomaly;
import fr.cnav.saturne.report.model.Context;
import java.math.BigInteger;
import java.util.Map;

public final class AnomalyHelper {
    private AnomalyHelper() {
    }

    public static String getIndividualValue(Anomaly anomaly, String categoryFullQualifiedId) {
        if (anomaly != null && categoryFullQualifiedId != null) {
            IndividualInformationDescriptor individualDescriptor = AnomalyHelper.getIndividualFromAnomaly(anomaly);
            return AnomalyHelper.getIndividualValue(individualDescriptor, categoryFullQualifiedId);
        }
        return "";
    }

    public static String getIndividualValue(IndividualInformationDescriptor individualDescriptor, String categoryFullQualifiedId) {
        String resultValue = null;
        if (individualDescriptor != null && categoryFullQualifiedId != null) {
            return individualDescriptor.getFieldFullQualifiedIdToValueMap().get(categoryFullQualifiedId);
        }
        return resultValue;
    }

    public static boolean isIndividualContext(Object object) {
        Map<Integer, IndividualInformationDescriptor> fieldLineNumberToIndividualDescriptorMap = MessageFile.getInstance().getFieldLineNumberToIndividualDescriptorMap();
        if (object instanceof Anomaly && fieldLineNumberToIndividualDescriptorMap != null) {
            Anomaly anomaly = (Anomaly)object;
            return fieldLineNumberToIndividualDescriptorMap.get(anomaly.getFieldLocalizer().getLineNumber()) != null;
        }
        return false;
    }

    public static IndividualInformationDescriptor getIndividualFromAnomaly(Anomaly anomaly) {
        Map<Integer, IndividualInformationDescriptor> fieldLineNumberToIndividualDescriptorMap = MessageFile.getInstance().getFieldLineNumberToIndividualDescriptorMap();
        if (anomaly != null && fieldLineNumberToIndividualDescriptorMap != null) {
            return fieldLineNumberToIndividualDescriptorMap.get(anomaly.getFieldLocalizer().getLineNumber());
        }
        return null;
    }

    public static String getFullQualifedId(Object anomaly) {
        if (anomaly instanceof Anomaly) {
            return ((Anomaly)anomaly).getFieldId();
        }
        return "";
    }

    public static String getNature(Object object, Map<Anomaly, Context> mapAnomaliesToContext, Map<Context, DeclarationDescription> mapContext2Declaration) {
        Anomaly anomaly;
        Context context;
        if (object instanceof Anomaly && mapContext2Declaration != null && (context = mapAnomaliesToContext.get(anomaly = (Anomaly)object)) != null && mapContext2Declaration.containsKey(context) && mapContext2Declaration.get(context) != null) {
            return mapContext2Declaration.get(context).getName();
        }
        return null;
    }

    public static Object getFirstAnomalieWithLine(BigInteger targetLine) {
        Anomaly firstAnomaly = null;
        if (MessageFile.getInstance() != null && targetLine != null) {
            for (Anomaly object : MessageFile.getInstance().getAnomalies()) {
                Anomaly anomaly;
                if (!(object instanceof Anomaly) || !targetLine.equals(BigInteger.valueOf((anomaly = object).getFieldLocalizer().getLineNumber()))) continue;
                firstAnomaly = anomaly;
            }
        }
        return firstAnomaly;
    }

    public static DeclarationDescription getDeclaration(Anomaly anomaly) {
        DeclarationDescription declaration = null;
        Context anomalyContext = MessageFile.getInstance().getContext(anomaly);
        if (anomalyContext != null && MessageFile.getInstance().getMapContext2Declaration() != null) {
            declaration = MessageFile.getInstance().getMapContext2Declaration().get(anomalyContext);
        }
        return declaration;
    }
}

