/*
 * Decompiled with CFR 0.152.
 */
package n4ds.dsn.p03v01.all.rules;

import fr.cnav.saturne.RuleCriticity;
import fr.cnav.saturne.api.model.access.BlockDescription;
import fr.cnav.saturne.api.model.access.DeclarationDescription;
import fr.cnav.saturne.api.model.access.StandardAccessor;
import fr.cnav.saturne.validator.TreeProcessingException;
import fr.cnav.saturne.validator.engine.IRule;
import fr.cnav.saturne.validator.engine.IRuleRegistry;
import fr.cnav.saturne.validator.engine.IRuleResult;
import fr.cnav.saturne.validator.message.api.IMessageBlock;
import fr.cnav.saturne.validator.report.IReportLogger;
import fr.cnav.saturne.validator.report.TooManyAnomaliesException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import n4ds.dsn.p03v01.all.rules.IExecutorAndCleaner;
import n4ds.dsn.p03v01.all.rules.RuleRegistryHelper;
import n4ds.dsn.p03v01.all.rules.RuleS21_G00_54_004_CCH_11;
import n4ds.dsn.p03v01.all.rules.RuleS21_G00_54_005_CSL_14;
import n4ds.dsn.p03v01.all.rules.StructureConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorAndCleanerS21_G00_54
implements IExecutorAndCleaner,
StructureConstants {
    private final Logger LOGGER = LoggerFactory.getLogger(ExecutorAndCleanerS21_G00_54.class);
    private final StandardAccessor modelAccessor;
    private final IRuleRegistry syntacticRuleRegistry;
    private final Properties ruleInhibitionProperties;
    final RuleS21_G00_54_004_CCH_11 ruleS21_G00_54_004_CCH_11;
    final RuleS21_G00_54_005_CSL_14 ruleS21_G00_54_005_CSL_14;

    public ExecutorAndCleanerS21_G00_54(StandardAccessor modelAccessor, IRuleRegistry syntacticRuleRegistry, Properties ruleInhibitionProperties) {
        this.modelAccessor = modelAccessor;
        this.syntacticRuleRegistry = syntacticRuleRegistry;
        this.ruleInhibitionProperties = ruleInhibitionProperties;
        this.ruleS21_G00_54_004_CCH_11 = new RuleS21_G00_54_004_CCH_11(modelAccessor);
        this.ruleS21_G00_54_005_CSL_14 = new RuleS21_G00_54_005_CSL_14(modelAccessor);
    }

    @Override
    public void runRules(IMessageBlock block, DeclarationDescription declaration, RuleRegistryHelper.NormDeclarationType declType, IReportLogger theReportLogger, boolean validateSyntactic, boolean validateSemantic, boolean unloadingActivated) throws TreeProcessingException {
        block14: {
            HashMap<String, Iterable<IMessageBlock>> msgBlockList;
            block16: {
                block15: {
                    msgBlockList = new HashMap<String, Iterable<IMessageBlock>>();
                    Iterable ctxt = Stream.of(block).collect(Collectors.toList());
                    msgBlockList.put("S21_G00_54", ctxt);
                    if (validateSyntactic) {
                        Set ruleSet = this.syntacticRuleRegistry.getRulesForContext((BlockDescription)block.getStandardBlockDescription(), declaration);
                        for (IRule rule : ruleSet) {
                            this.checkRule(rule, block, theReportLogger);
                        }
                    }
                    if (unloadingActivated) {
                        block.eraseField(1);
                    }
                    if (!validateSemantic) break block14;
                    if (declType == null) break block15;
                    switch (declType) {
                        case DSN_Mensuelle: {
                            this.executeRulesForDeclDSN_Mensuelle(theReportLogger, msgBlockList);
                            break block16;
                        }
                        case DSN_SIGNAL_REPRISE_TRAVAIL: {
                            this.executeRulesForDeclDSN_SIGNAL_REPRISE_TRAVAIL(theReportLogger, msgBlockList);
                            break block16;
                        }
                        case DSN_SIGNAL_ARRET_TRAVAIL: {
                            this.executeRulesForDeclDSN_SIGNAL_ARRET_TRAVAIL(theReportLogger, msgBlockList);
                            break block16;
                        }
                        case DSN_SIGNAL_FIN_CONTRAT_UNIQUE: {
                            this.executeRulesForDeclDSN_SIGNAL_FIN_CONTRAT_UNIQUE(theReportLogger, msgBlockList);
                            break block16;
                        }
                        case DSN_SIGNAL_AMORCAGE: {
                            this.executeRulesForDeclDSN_SIGNAL_AMORCAGE(theReportLogger, msgBlockList);
                            break block16;
                        }
                        case DSN_SUBSTITUTION: {
                            this.executeRulesForDeclDSN_SUBSTITUTION(theReportLogger, msgBlockList);
                            break block16;
                        }
                        case DSN_SIGNAL_DECLARATION_PREALABLE_EMBAUCHE: {
                            this.executeRulesForDeclDSN_SIGNAL_DECLARATION_PREALABLE_EMBAUCHE(theReportLogger, msgBlockList);
                            break block16;
                        }
                        case DSN_NEANT: {
                            this.executeRulesForDeclDSN_NEANT(theReportLogger, msgBlockList);
                            break block16;
                        }
                        default: {
                            throw new IllegalArgumentException();
                        }
                    }
                }
                this.executeAllRules(theReportLogger, msgBlockList);
            }
            if (unloadingActivated) {
                this.removeField((Iterable)msgBlockList.get("S21_G00_54"), 2);
            }
        }
    }

    private void executeRulesForDeclDSN_Mensuelle(IReportLogger theReportLogger, Map<String, Iterable<IMessageBlock>> msgBlockList) throws TreeProcessingException {
        for (IMessageBlock blockRuleCtxt : msgBlockList.get("S21_G00_54")) {
            this.execRule((IRule)this.ruleS21_G00_54_004_CCH_11, "S21.G00.54.004/CCH-11", blockRuleCtxt, theReportLogger);
            this.execRule((IRule)this.ruleS21_G00_54_005_CSL_14, "S21.G00.54.005/CSL-14", blockRuleCtxt, theReportLogger);
        }
    }

    private void executeRulesForDeclDSN_SIGNAL_REPRISE_TRAVAIL(IReportLogger theReportLogger, Map<String, Iterable<IMessageBlock>> msgBlockList) throws TreeProcessingException {
    }

    private void executeRulesForDeclDSN_SIGNAL_ARRET_TRAVAIL(IReportLogger theReportLogger, Map<String, Iterable<IMessageBlock>> msgBlockList) throws TreeProcessingException {
    }

    private void executeRulesForDeclDSN_SIGNAL_FIN_CONTRAT_UNIQUE(IReportLogger theReportLogger, Map<String, Iterable<IMessageBlock>> msgBlockList) throws TreeProcessingException {
        for (IMessageBlock blockRuleCtxt : msgBlockList.get("S21_G00_54")) {
            this.execRule((IRule)this.ruleS21_G00_54_004_CCH_11, "S21.G00.54.004/CCH-11", blockRuleCtxt, theReportLogger);
            this.execRule((IRule)this.ruleS21_G00_54_005_CSL_14, "S21.G00.54.005/CSL-14", blockRuleCtxt, theReportLogger);
        }
    }

    private void executeRulesForDeclDSN_SIGNAL_AMORCAGE(IReportLogger theReportLogger, Map<String, Iterable<IMessageBlock>> msgBlockList) throws TreeProcessingException {
    }

    private void executeRulesForDeclDSN_SUBSTITUTION(IReportLogger theReportLogger, Map<String, Iterable<IMessageBlock>> msgBlockList) throws TreeProcessingException {
    }

    private void executeRulesForDeclDSN_SIGNAL_DECLARATION_PREALABLE_EMBAUCHE(IReportLogger theReportLogger, Map<String, Iterable<IMessageBlock>> msgBlockList) throws TreeProcessingException {
    }

    private void executeRulesForDeclDSN_NEANT(IReportLogger theReportLogger, Map<String, Iterable<IMessageBlock>> msgBlockList) throws TreeProcessingException {
        for (IMessageBlock blockRuleCtxt : msgBlockList.get("S21_G00_54")) {
            this.execRule((IRule)this.ruleS21_G00_54_005_CSL_14, "S21.G00.54.005/CSL-14", blockRuleCtxt, theReportLogger);
        }
    }

    private void executeAllRules(IReportLogger theReportLogger, Map<String, Iterable<IMessageBlock>> msgBlockList) throws TreeProcessingException {
        for (IMessageBlock blockRuleCtxt : msgBlockList.get("S21_G00_54")) {
            this.execRule((IRule)this.ruleS21_G00_54_004_CCH_11, "S21.G00.54.004/CCH-11", blockRuleCtxt, theReportLogger);
            this.execRule((IRule)this.ruleS21_G00_54_005_CSL_14, "S21.G00.54.005/CSL-14", blockRuleCtxt, theReportLogger);
        }
    }

    private void checkRule(IRule rule, IMessageBlock messageBlock, IReportLogger reportLogger) throws TreeProcessingException {
        IRuleResult result = null;
        try {
            result = rule.run(messageBlock);
        }
        catch (Exception e) {
            this.LOGGER.error("Problem with the executed rule " + rule.getClass().getSimpleName() + " - " + e.getClass().getName() + ", message = " + e.getMessage());
            if (e.getCause() != null && e.getCause() != e) {
                this.LOGGER.error(String.valueOf(e.getCause().getClass().getName()) + ", message = " + e.getCause().getMessage());
            }
            this.LOGGER.warn("EXC-3 : The rule ''" + rule.getCode() + "'' cause an unexpected exception : " + e.getMessage(), (Throwable)e);
        }
        this.reportResult(result, reportLogger);
    }

    private void reportResult(IRuleResult result, IReportLogger reportLogger) throws TreeProcessingException {
        Boolean resultSuccess;
        if (result != null && !(resultSuccess = (Boolean)result.getResult()).booleanValue()) {
            try {
                reportLogger.logResult(result);
            }
            catch (TooManyAnomaliesException e) {
                throw new TreeProcessingException((Throwable)e);
            }
        }
    }

    private void execRule(IRule rule, String ruleFullId, IMessageBlock blockRuleCtxt, IReportLogger theReportLogger) throws TreeProcessingException {
        if (this.ruleInhibitionProperties == null || this.ruleInhibitionProperties.get(ruleFullId) == null || !RuleCriticity.INACTIVE.getLiteral().toLowerCase().equals(this.ruleInhibitionProperties.get(ruleFullId).toString().toLowerCase())) {
            this.checkRule(rule, blockRuleCtxt, theReportLogger);
        }
    }

    private void removeField(Iterable<IMessageBlock> blockIt, int fieldToClean) {
        for (IMessageBlock blockParent : blockIt) {
            blockParent.eraseField(fieldToClean);
        }
    }
}

