/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.report.impl;

import fr.cnav.saturne.Block;
import fr.cnav.saturne.BlockContext;
import fr.cnav.saturne.FieldContext;
import fr.cnav.saturne.ReportConfiguration;
import fr.cnav.saturne.Standard;
import fr.cnav.saturne.report.model.Context;
import fr.cnav.saturne.validator.message.api.IMessageBlock;
import fr.cnav.saturne.validator.message.api.IMessageField;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;

public class ReportContextDescriptor {
    public static final String NO_REPORT_CONFIGURATION_ERROR = "The standard model must contain a ReportConfiguration.";
    public static final String VALIDATION_ID_SERIALISATION_NAME = "validationID";
    public static final String VALIDATION_TIMESTAMP_SERIALISATION_NAME = "validation_execution_date";
    private Map<String, BlockContext> blockIdToContextElement = new HashMap<String, BlockContext>();
    private Map<String, Set<String>> blockIdToSubContextSerializationName;
    private Map<String, FieldContext> fieldsIdToContextElement = new HashMap<String, FieldContext>();
    private ReportConfiguration reportConfiguration;

    public ReportContextDescriptor(Standard standard) {
        this.blockIdToSubContextSerializationName = new HashMap<String, Set<String>>();
        this.reportConfiguration = standard.getReportConfiguration();
        if (this.reportConfiguration == null) {
            throw new IllegalStateException(NO_REPORT_CONFIGURATION_ERROR);
        }
        this.fillBlocksIdToContextBlockElementMap(this.reportConfiguration);
        this.fillBlocksIdToSubContextSerializationName(this.reportConfiguration);
        EList fieldContexts = this.reportConfiguration.getFieldContexts();
        for (FieldContext fieldContext : fieldContexts) {
            this.fieldsIdToContextElement.put(fieldContext.getField().getFullQualifiedId(), fieldContext);
        }
    }

    private void fillBlocksIdToSubContextSerializationName(ReportConfiguration theReportConfiguration) {
        EList blockContexts = theReportConfiguration.getBlockContexts();
        this.blockIdToSubContextSerializationName.put(theReportConfiguration.getBlock().getFullQualifiedId(), new HashSet());
        for (BlockContext blockContext : blockContexts) {
            HashSet serializationNameSet = new HashSet();
            this.blockIdToSubContextSerializationName.put(blockContext.getBlock().getFullQualifiedId(), serializationNameSet);
        }
        for (BlockContext blockContext : blockContexts) {
            String parentContextBlockId = this.getBlockIdOfParentContext(blockContext, theReportConfiguration);
            Set<String> serializationNameSet = this.blockIdToSubContextSerializationName.get(parentContextBlockId);
            serializationNameSet.add(blockContext.getName());
        }
    }

    private String getBlockIdOfParentContext(BlockContext blockContext, ReportConfiguration theReportConfiguration) {
        Block block = blockContext.getBlock();
        String blockIdResult = null;
        Block parentBlock = (Block)block.eContainer();
        while (blockIdResult == null) {
            if (parentBlock.equals(theReportConfiguration.getBlock())) {
                blockIdResult = parentBlock.getFullQualifiedId();
            } else {
                for (BlockContext blockContext2 : theReportConfiguration.getBlockContexts()) {
                    if (!blockContext2.getBlock().equals(parentBlock)) continue;
                    blockIdResult = parentBlock.getFullQualifiedId();
                }
            }
            if (blockIdResult != null) continue;
            parentBlock = (Block)parentBlock.eContainer();
        }
        return blockIdResult;
    }

    public Set<String> getDirectSubContextSerializationNames(Context context) {
        return this.blockIdToSubContextSerializationName.get(context.getblockQualifiedId());
    }

    private void fillBlocksIdToContextBlockElementMap(ReportConfiguration rootBlockContext) {
        EList blockContexts = rootBlockContext.getBlockContexts();
        for (BlockContext blockContext : blockContexts) {
            this.blockIdToContextElement.put(blockContext.getBlock().getFullQualifiedId(), blockContext);
        }
    }

    public boolean isABlockContext(IMessageBlock block) {
        boolean isABlockContext = this.reportConfiguration.getBlock().getFullQualifiedId().equals(block.getStandardBlockDescription().getFullQualifiedId());
        if (!isABlockContext) {
            isABlockContext = this.blockIdToContextElement.keySet().contains(block.getStandardBlockDescription().getFullQualifiedId());
        }
        return isABlockContext;
    }

    public boolean isABlockRootContext(IMessageBlock block) {
        boolean isABlockContext = this.reportConfiguration.getBlock().getFullQualifiedId().equals(block.getStandardBlockDescription().getFullQualifiedId());
        return isABlockContext;
    }

    public boolean isABlockContext(String blockFullQualifiedId) {
        boolean isABlockContext = this.reportConfiguration.getBlock().getFullQualifiedId().equals(blockFullQualifiedId);
        if (!isABlockContext) {
            isABlockContext = this.blockIdToContextElement.keySet().contains(blockFullQualifiedId);
        }
        return isABlockContext;
    }

    public boolean isFieldInContext(IMessageField<?> field) {
        return this.fieldsIdToContextElement.keySet().contains(field.getStandardFieldDescription().getFullQualifiedId());
    }

    public boolean isFieldInContext(String fieldFullQualifiedId) {
        return this.fieldsIdToContextElement.keySet().contains(fieldFullQualifiedId);
    }

    public Context getNewContext(IMessageBlock block) {
        boolean isRootContext = this.reportConfiguration.getBlock().getFullQualifiedId().equals(block.getStandardBlockDescription().getFullQualifiedId());
        if (isRootContext) {
            return new Context(this.reportConfiguration.getName(), this.reportConfiguration.isStrictSelf(), this.reportConfiguration.isStrictSubContexts(), this.reportConfiguration.getBlock().getFullQualifiedId(), this.reportConfiguration.isUseAnomalyCounter(), this.reportConfiguration.isUseTotalAnomalyCounter());
        }
        String blockId = block.getStandardBlockDescription().getFullQualifiedId();
        BlockContext blockContext = this.blockIdToContextElement.get(blockId);
        return new Context(blockContext.getName(), blockContext.isStrictSelf(), blockContext.isStrictSubContexts(), blockId, blockContext.isUseAnomalyCounter(), blockContext.isUseAnomalyCounter());
    }

    public Context getRootContext() {
        return new Context(this.reportConfiguration.getName(), this.reportConfiguration.isStrictSelf(), this.reportConfiguration.isStrictSubContexts(), this.reportConfiguration.getBlock().getFullQualifiedId(), this.reportConfiguration.isUseAnomalyCounter(), this.reportConfiguration.isUseTotalAnomalyCounter());
    }

    public String getSerializationName(String contextFieldFullQualifiedId) {
        FieldContext fieldContext = this.fieldsIdToContextElement.get(contextFieldFullQualifiedId);
        return fieldContext.getName();
    }

    public boolean doAddValidationIdContext() {
        return this.reportConfiguration.isSerializeValidationId();
    }

    public boolean doAddValidationTimeStampContext() {
        return this.reportConfiguration.isSerializeValidationExecutionTime();
    }

    public boolean hasContext() {
        return this.fieldsIdToContextElement.size() > 0;
    }

    public Map<String, BlockContext> getBlockIdToContextElement() {
        return this.blockIdToContextElement;
    }
}

