/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.report.impl;

import fr.cnav.saturne.report.model.Anomaly;
import fr.cnav.saturne.report.model.Context;
import fr.cnav.saturne.validator.conversion.xml.XMLFormattingWriter;
import fr.cnav.saturne.validator.report.IReportLogger;
import fr.cnav.saturne.validator.report.SerializationException;
import fr.cnav.saturne.validator.report.impl.GenericXMLReportSerializerHandler;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.List;

public class GenericXMLReportSerializerHandlerSorted
extends GenericXMLReportSerializerHandler {
    private Comparator<Anomaly> comparator = new Comparator<Anomaly>(){

        @Override
        public int compare(Anomaly o1, Anomaly o2) {
            if (o1.getFieldLocalizer().getLineNumber() != o2.getFieldLocalizer().getLineNumber()) {
                if (o1.getFieldId().compareTo(o2.getFieldId()) != 0) {
                    return o1.getCode().compareTo(o2.getCode());
                }
                return o1.getFieldId().compareTo(o2.getFieldId());
            }
            return Integer.compare(o1.getFieldLocalizer().getLineNumber(), o2.getFieldLocalizer().getLineNumber());
        }
    };

    public GenericXMLReportSerializerHandlerSorted(IReportLogger reportLogger, String namespacePrefix, String namespace, String messageName, OutputStream outputStream, String encoding) throws SerializationException {
        super(reportLogger, namespacePrefix, namespace, messageName, outputStream, encoding);
    }

    public GenericXMLReportSerializerHandlerSorted(IReportLogger reportLogger, String namespacePrefix, String namespace, String messageName, XMLFormattingWriter writer) throws SerializationException {
        super(reportLogger, namespacePrefix, namespace, messageName, writer);
    }

    @Override
    protected List<Anomaly> getAnomalies(Context context) {
        List<Anomaly> anomalies = super.getAnomalies(context);
        anomalies.stream().sorted(this.comparator);
        return anomalies;
    }
}

