/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.positional.conversion;

import fr.cnav.saturne.validator.positional.FormatSpecification;
import fr.cnav.saturne.validator.positional.RecordIdSpecification;
import fr.cnav.saturne.validator.positional.conversion.AbstractIdExtractor;
import java.io.InputStream;
import java.util.Comparator;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;

public class GenericIdExtractor
extends AbstractIdExtractor {
    public GenericIdExtractor(FormatSpecification format, InputStream inputStream) {
        super(format, inputStream);
    }

    @Override
    public String extractId(int lineNumber, String recordContent) {
        EList<RecordIdSpecification> idSpecifications = this.getFormat().getIdSpecifications();
        ECollections.sort(idSpecifications, (Comparator)new Comparator<RecordIdSpecification>(){

            @Override
            public int compare(RecordIdSpecification o1, RecordIdSpecification o2) {
                int result = 0;
                if (o1.getRecordTypeEndPosition() > o2.getRecordTypeEndPosition()) {
                    result = 1;
                } else if (o1.getRecordTypeEndPosition() < o2.getRecordTypeEndPosition()) {
                    result = -1;
                }
                return result;
            }
        });
        StringBuilder id = new StringBuilder();
        for (RecordIdSpecification recordIdSpecification : idSpecifications) {
            if (recordContent.length() < recordIdSpecification.getRecordTypeEndPosition()) continue;
            id.append(recordContent.substring(recordIdSpecification.getRecordTypeStartPosition() - 1, recordIdSpecification.getRecordTypeEndPosition()));
        }
        return id.toString();
    }
}

