/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.message;

import fr.cnav.saturne.api.model.access.FieldDescription;
import fr.cnav.saturne.validator.IFieldLocalizer;
import fr.cnav.saturne.validator.message.MessageField;
import fr.cnav.saturne.validator.message.api.IMessageBlock;
import fr.cnav.saturne.validator.message.api.IMessageFieldNum;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;

public class MessageFieldNum
extends MessageField<BigDecimal>
implements IMessageFieldNum {
    public MessageFieldNum(IMessageBlock parent, FieldDescription field, String originalValue, BigDecimal value, int index, IFieldLocalizer fieldLocalizer) {
        super(parent, field, value, originalValue, index, fieldLocalizer);
    }

    @Override
    public String getValueAsString() {
        return this.originalValue;
    }

    @Override
    public String getOriginalValue() {
        return this.originalValue;
    }

    @Override
    public boolean eq(BigDecimal value) {
        return value == null ? false : value.doubleValue() == ((BigDecimal)this.value).doubleValue();
    }

    @Override
    public boolean neq(BigDecimal value) {
        return value == null ? false : value.doubleValue() != ((BigDecimal)this.value).doubleValue();
    }

    @Override
    public boolean lt(BigDecimal value) {
        return value == null ? false : value.doubleValue() > ((BigDecimal)this.value).doubleValue();
    }

    @Override
    public boolean le(BigDecimal value) {
        return value == null ? false : value.doubleValue() >= ((BigDecimal)this.value).doubleValue();
    }

    @Override
    public BigDecimal add(IMessageFieldNum other) {
        return ((BigDecimal)this.getValue()).add((BigDecimal)other.getValue());
    }

    @Override
    public BigDecimal add(BigDecimal value) {
        return ((BigDecimal)this.getValue()).add(value);
    }

    @Override
    public BigDecimal subtract(IMessageFieldNum other) {
        return ((BigDecimal)this.getValue()).subtract((BigDecimal)other.getValue());
    }

    @Override
    public BigDecimal subtract(BigDecimal value) {
        return ((BigDecimal)this.getValue()).subtract(value);
    }

    @Override
    public BigDecimal multiply(IMessageFieldNum other) {
        return ((BigDecimal)this.getValue()).multiply((BigDecimal)other.getValue());
    }

    @Override
    public BigDecimal multiply(BigDecimal value) {
        return ((BigDecimal)this.getValue()).multiply(value);
    }

    @Override
    public BigDecimal divide(IMessageFieldNum other) {
        return this.divide(other, 4).stripTrailingZeros();
    }

    @Override
    public BigDecimal divide(IMessageFieldNum other, int scale) {
        return ((BigDecimal)this.getValue()).divide((BigDecimal)other.getValue(), scale, RoundingMode.HALF_UP).stripTrailingZeros();
    }

    @Override
    public BigDecimal divide(BigDecimal value) {
        return this.divide(value, 4).stripTrailingZeros();
    }

    @Override
    public BigDecimal divide(BigDecimal value, int scale) {
        return ((BigDecimal)this.getValue()).divide(value, scale, RoundingMode.HALF_UP).stripTrailingZeros();
    }

    @Override
    public boolean gt(BigDecimal value) {
        return value == null ? false : value.doubleValue() < ((BigDecimal)this.value).doubleValue();
    }

    @Override
    public boolean ge(BigDecimal value) {
        return value == null ? false : value.doubleValue() <= ((BigDecimal)this.value).doubleValue();
    }

    @Override
    public boolean in(Collection<?> values) {
        boolean result = false;
        if (values == null) {
            return result;
        }
        for (Object value : values) {
            if (!(value instanceof BigDecimal) || !this.eq((BigDecimal)value)) continue;
            result = true;
            break;
        }
        return result;
    }
}

