/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.impl;

import fr.cnav.saturne.Block;
import fr.cnav.saturne.DataType;
import fr.cnav.saturne.DeclarationBlock;
import fr.cnav.saturne.Field;
import fr.cnav.saturne.Message;
import fr.cnav.saturne.Standard;
import fr.cnav.saturne.validator.IStandard;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;

public class StandardImpl
implements IStandard {
    private final Map<String, Block> fieldIdToParentBlocMap;
    private final Map<String, String> blocIdToParentBlocMap;
    private final Map<String, Block> blocIdToBlocMap;
    private final Map<String, DataType> fieldIdToDataType = new HashMap<String, DataType>();
    private final Map<String, String> blocIdToDeclarationName;
    private final String rootMessageName;
    private String declarationBlockId;
    private final String messageId;

    public StandardImpl(Standard standard) {
        this.blocIdToBlocMap = new HashMap<String, Block>();
        this.blocIdToParentBlocMap = new HashMap<String, String>();
        this.fieldIdToParentBlocMap = new HashMap<String, Block>();
        this.blocIdToDeclarationName = new HashMap<String, String>();
        this.rootMessageName = standard.getMessage().getName();
        this.messageId = standard.getMessage().getFullQualifiedId();
        this.fillMaps(standard);
    }

    @Override
    public String getMessageName() {
        return this.rootMessageName;
    }

    private void fillMaps(Standard standard) {
        Message message = standard.getMessage();
        this.blocIdToParentBlocMap.put(message.getHeaderBlock().getFullQualifiedId(), message.getFullQualifiedId());
        this.blocIdToParentBlocMap.put(message.getFooterBlock().getFullQualifiedId(), message.getFullQualifiedId());
        this.fillMaps((Block)message.getHeaderBlock());
        this.fillMaps(message.getFooterBlock());
    }

    private void fillMaps(Block block) {
        EList childrenBlocks = block.getChildrenBlocks();
        for (Block blockChild : childrenBlocks) {
            this.blocIdToParentBlocMap.put(blockChild.getFullQualifiedId(), block.getFullQualifiedId());
            this.fillMaps(blockChild);
        }
        for (Field field : block.getChildrenFields()) {
            this.fieldIdToParentBlocMap.put(field.getFullQualifiedId(), block);
            this.fieldIdToDataType.put(field.getFullQualifiedId(), field.getDataType());
        }
        this.blocIdToBlocMap.put(block.getFullQualifiedId(), block);
        if (block instanceof DeclarationBlock) {
            this.blocIdToDeclarationName.put(block.getFullQualifiedId(), block.getName());
        }
        if (block instanceof DeclarationBlock) {
            this.declarationBlockId = block.getFullQualifiedId();
        }
    }

    @Override
    public String getParentBlocId(String fieldOrBlocId) {
        String parentId = this.blocIdToParentBlocMap.get(fieldOrBlocId);
        if (parentId == null && this.fieldIdToParentBlocMap.get(fieldOrBlocId) != null) {
            parentId = this.fieldIdToParentBlocMap.get(fieldOrBlocId).getFullQualifiedId();
        }
        return parentId;
    }

    @Override
    public int getBlocFieldNumber(String blocId) {
        Block block = this.blocIdToBlocMap.get(blocId);
        if (block == null) {
            return -1;
        }
        return block.getChildrenFields().size();
    }

    @Override
    public DataType getDataType(String fieldId) {
        return this.fieldIdToDataType.get(fieldId);
    }

    @Override
    public boolean doesFieldExistInNorm(String fieldId) {
        return this.fieldIdToParentBlocMap.get(fieldId) != null;
    }

    @Override
    public boolean doesFieldBelongToBloc(Block bloc, Field field) {
        Block block;
        return bloc != null && field != null && (block = this.fieldIdToParentBlocMap.get(field.getId())) != null && bloc.getId().equals(block.getFullQualifiedId());
    }

    @Override
    public boolean isBlocADeclarationOne(String blocId) {
        return this.declarationBlockId.equals(blocId);
    }

    @Override
    public String getMessageId() {
        return this.messageId;
    }

    @Override
    public boolean isBlocId(String id) {
        return this.blocIdToBlocMap.containsKey(id);
    }

    @Override
    public boolean isFieldId(String id) {
        return this.fieldIdToDataType.containsKey(id);
    }
}

