/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.functions;

import fr.cnav.saturne.IdQualifiedElement;
import fr.cnav.saturne.Standard;
import fr.cnav.saturne.api.model.access.StandardAccessor;
import fr.cnav.saturne.api.model.access.StandardDescription;
import fr.cnav.saturne.options.Key;
import fr.cnav.saturne.options.OptionMap;
import fr.cnav.saturne.validator.ControlMessages;
import fr.cnav.saturne.validator.ISequenceProvider;
import fr.cnav.saturne.validator.ITreeConsumer;
import fr.cnav.saturne.validator.IValidationOptions;
import fr.cnav.saturne.validator.SaturneValidatorException;
import fr.cnav.saturne.validator.TreeProcessingException;
import fr.cnav.saturne.validator.api.AbstractKBDescriptor;
import fr.cnav.saturne.validator.conversion.ConversionSerializationException;
import fr.cnav.saturne.validator.conversion.OriginalValueOptionValue;
import fr.cnav.saturne.validator.conversion.TreeBuilder;
import fr.cnav.saturne.validator.conversion.xml.XMLSerializer;
import fr.cnav.saturne.validator.conversion.xml.XMLUtil;
import fr.cnav.saturne.validator.engine.IExecutorAndCleanerRunner;
import fr.cnav.saturne.validator.engine.IRuleRegistry;
import fr.cnav.saturne.validator.engine.ValidatorWithCleaner;
import fr.cnav.saturne.validator.functions.HelperConversion;
import fr.cnav.saturne.validator.functions.HelperRulesProperties;
import fr.cnav.saturne.validator.functions.HelperSerialisation;
import fr.cnav.saturne.validator.functions.ValidationFunctionException;
import fr.cnav.saturne.validator.functions.ValidationFunctionsHelper;
import fr.cnav.saturne.validator.impl.FormatType;
import fr.cnav.saturne.validator.message.MessageRecuperator;
import fr.cnav.saturne.validator.message.api.IMessageBlock;
import fr.cnav.saturne.validator.report.IReportLogger;
import fr.cnav.saturne.validator.report.IReportSerializer;
import fr.cnav.saturne.validator.report.ReportContextCalculator;
import fr.cnav.saturne.validator.report.SerializationException;
import fr.cnav.saturne.validator.report.TooManyAnomaliesException;
import fr.cnav.saturne.validator.report.impl.ReportContextDescriptor;
import fr.cnav.saturne.validator.syntax.SyntacticRuleRegistry;
import fr.cnav.saturne.validator.xml.XMLReader;
import fr.cnav.saturne.validator.xml.XMLReaderWithDecl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidParameterException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractValidationFunctions {
    protected final boolean doFiltersSecondaryAnomalies;
    protected Properties controlsProperties;
    protected final IExecutorAndCleanerRunner executorAndCleanerRunner;
    protected Boolean unloadingAcitvated;
    protected Boolean stopOnSyntacticError;
    protected Boolean stopOnConversionError;
    protected final IFile standardFile;
    protected IMessageBlock rootMessageBlock;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ControlMessages controlMessages;
    private final OptionMap options;
    private final StandardAccessor modelAccessor;
    private final AbstractKBDescriptor kbDescriptor;
    private final Map<String, String> xmlTag2QualifiedId;
    private final StandardDescription standardDescription;
    private final Standard standard;
    private OriginalValueOptionValue emitOriginalValue;
    private boolean emitOriginalLineNumber;
    private final IRuleRegistry syntacticRuleRegistry;
    private ReportContextDescriptor reportContextDescriptor;
    private HelperSerialisation helperSerialisation;
    private HelperConversion helperConversion;
    private HelperRulesProperties helperRulesProperties;

    public AbstractValidationFunctions(ControlMessages controlMessages, OptionMap applicationOptionsMap, AbstractKBDescriptor kbDescriptor) throws ValidationFunctionException {
        this.controlMessages = controlMessages;
        if (controlMessages == null) {
            throw new ValidationFunctionException("The given controls message component is null");
        }
        this.kbDescriptor = kbDescriptor;
        this.modelAccessor = kbDescriptor.getStandardAccessor();
        this.options = applicationOptionsMap;
        this.standardDescription = this.modelAccessor.getStandardDescription();
        this.standard = this.modelAccessor.getStandard();
        this.helperRulesProperties = new HelperRulesProperties();
        this.xmlTag2QualifiedId = this.initializeMap(this.standardDescription);
        Key keyOriginalLineNumber = new Key("line.number.location");
        Boolean optionOriginalLineNumberValue = (Boolean)applicationOptionsMap.getOption(keyOriginalLineNumber);
        this.emitOriginalLineNumber = this.getOriginalLineNumber(optionOriginalLineNumberValue);
        Key keyOriginalValue = new Key("fr.cnav.norme.val.originalValue");
        OriginalValueOptionValue optionOriginalValueValue = (OriginalValueOptionValue)((Object)applicationOptionsMap.getOption(keyOriginalValue));
        this.emitOriginalValue = this.getOriginalValue(optionOriginalValueValue);
        Key filtersSecondaryAnomaliesKey = new Key("fr.cnav.norme.val.anomaliesInhibiting");
        Boolean optionFiltersSecondaryAnomalies = (Boolean)applicationOptionsMap.getOption(filtersSecondaryAnomaliesKey);
        this.doFiltersSecondaryAnomalies = this.getFiltersSecondaryAnomalies(optionFiltersSecondaryAnomalies);
        this.syntacticRuleRegistry = new SyntacticRuleRegistry(this.modelAccessor, controlMessages);
        this.controlsProperties = this.getRulesProperties(kbDescriptor);
        this.unloadingAcitvated = (Boolean)applicationOptionsMap.getOption(new Key("fr.cnav.saturne.validator.unloadingActivated"));
        if (this.unloadingAcitvated == null) {
            this.unloadingAcitvated = true;
        }
        this.stopOnSyntacticError = (Boolean)applicationOptionsMap.getOption(new Key("stop.on.syntactic.error"));
        if (this.stopOnSyntacticError == null) {
            this.stopOnSyntacticError = false;
        }
        this.stopOnConversionError = (Boolean)applicationOptionsMap.getOption(new Key("stop.on.conversion.error"));
        if (this.stopOnConversionError == null) {
            this.stopOnConversionError = false;
        }
        OptionMap optionMapForKBDescriptor = new OptionMap();
        optionMapForKBDescriptor.setOption(new Key("fr.cnav.saturne.validator.syntacticRuleRegistry"), (Object)this.getSyntacticRuleRegistry());
        optionMapForKBDescriptor.setOption(new Key("fr.cnav.saturne.validator.ruleInhibitionProperties"), (Object)this.controlsProperties);
        kbDescriptor.initKBDescriptor(optionMapForKBDescriptor);
        this.executorAndCleanerRunner = (IExecutorAndCleanerRunner)kbDescriptor.getOptions().getOption(new Key("fr.cnav.saturne.validator.executorAndCleanerRunner"));
        this.standardFile = (IFile)this.options.getOption(new Key("fr.cnav.saturne.kbdescriptor.init.workspace.norm.file"));
        if (this.executorAndCleanerRunner == null && this.standardFile == null) {
            throw new InvalidParameterException(String.format("The kbDescriptor should containt an IExecutorAndCleanerRunner in key %s", "fr.cnav.saturne.validator.executorAndCleanerRunner"));
        }
        FormatType inputFileFormat = (FormatType)((Object)applicationOptionsMap.getOption(new Key("fr.cnav.saturne.validator.inputFormatValidation")));
        if (inputFileFormat != null) {
            kbDescriptor.getOptions().setOption(new Key("fr.cnav.saturne.validator.inputFormatValidation"), (Object)inputFileFormat);
        }
        this.helperSerialisation = new HelperSerialisation(kbDescriptor, this.emitOriginalValue, this.emitOriginalLineNumber);
        this.helperConversion = new HelperConversion(kbDescriptor, controlMessages, applicationOptionsMap, this.emitOriginalValue, this.emitOriginalLineNumber);
    }

    private boolean getFiltersSecondaryAnomalies(Boolean optionFiltersSecondaryAnomalies) {
        if (optionFiltersSecondaryAnomalies != null) {
            return optionFiltersSecondaryAnomalies;
        }
        return true;
    }

    private OriginalValueOptionValue getOriginalValue(OriginalValueOptionValue optionOriginalValueValue) {
        if (optionOriginalValueValue != null) {
            return optionOriginalValueValue;
        }
        return IValidationOptions.DEFAULT_OUTPUT_ORIGINAL_VALUES;
    }

    private Boolean getOriginalLineNumber(Boolean optionOriginalLineNumberValue) {
        if (optionOriginalLineNumberValue != null) {
            return optionOriginalLineNumberValue;
        }
        return true;
    }

    public IMessageBlock getRootMessageBlock() {
        return this.rootMessageBlock;
    }

    public AbstractKBDescriptor getKbDescriptor() {
        return this.kbDescriptor;
    }

    private Properties getRulesProperties(AbstractKBDescriptor registeredKBDescriptor) throws ValidationFunctionException {
        return this.helperRulesProperties.getRulesProperties(registeredKBDescriptor);
    }

    public ControlMessages getControlMessages() {
        return this.controlMessages;
    }

    public Properties getControlsProperties() {
        return this.controlsProperties;
    }

    public OptionMap getOptions() {
        return this.options;
    }

    public void serializeToXML(IMessageBlock message, OutputStream xmlOutput, String encoding) throws IOException, ValidationFunctionException {
        this.helperSerialisation.serializeToXML(message, xmlOutput, encoding);
    }

    public void serializeToXML(IMessageBlock messageBlock, ITreeConsumer serializer) throws IOException, ValidationFunctionException {
        this.helperSerialisation.serializeToXML(messageBlock, serializer);
    }

    public IMessageBlock convert(InputStream textInput, IReportLogger reportLogger) throws IOException, ValidationFunctionException, TooManyAnomaliesException {
        return this.helperConversion.convert(textInput, reportLogger);
    }

    public IMessageBlock readXML(InputStream xmlInput, IReportLogger reportLogger) throws TooManyAnomaliesException, ValidationFunctionException, IOException {
        this.logger.info("[Saturne] Start of the reading of an XML message");
        if (xmlInput == null) {
            throw new IllegalArgumentException("The parameter inputStream of the conversion method can't be null");
        }
        if (reportLogger == null) {
            throw new IllegalArgumentException("The parameter reportLogger cannot be null");
        }
        boolean xmlNoPrefix = this.getXmlNoPrefix();
        XMLReader xmlReader = new XMLReader(reportLogger, this.options, this.modelAccessor, this.xmlTag2QualifiedId, this.controlMessages, true, xmlNoPrefix);
        MessageRecuperator messageConstructor = new MessageRecuperator();
        xmlReader.addConsumer(messageConstructor);
        xmlReader.addConsumer(reportLogger);
        try {
            xmlReader.read(xmlInput);
        }
        catch (TreeProcessingException e) {
            if (e.getCause() instanceof TooManyAnomaliesException) {
                TooManyAnomaliesException t = (TooManyAnomaliesException)e.getCause();
                throw t;
            }
            this.logger.error("[Saturne] The conversion of an XML message into a MessageBlock has failed", (Throwable)e);
            throw new ValidationFunctionException(e);
        }
        this.logger.info("[Saturne] End of the reading of an XML message");
        return messageConstructor.getRootMessageBlock();
    }

    private boolean getXmlNoPrefix() {
        Key xmlNoPrefixKey = new Key("fr.cnav.saturne.validator.xmlWithNoPrefix");
        Boolean xmlNoPrefix = (Boolean)this.options.getOption(xmlNoPrefixKey);
        if (xmlNoPrefix == null) {
            xmlNoPrefix = false;
        }
        return xmlNoPrefix;
    }

    private Map<String, String> initializeMap(StandardDescription theStandard) {
        HashMap<String, String> map = new HashMap<String, String>();
        TreeIterator iterator = this.standard.getMessage().eAllContents();
        while (iterator.hasNext()) {
            EObject eObject = (EObject)iterator.next();
            if (!(eObject instanceof IdQualifiedElement)) continue;
            String id = ((IdQualifiedElement)eObject).getFullQualifiedId();
            map.put(XMLUtil.getTagNameFromQualifiedId(id), id);
        }
        map.put(XMLUtil.getTagNameFromQualifiedId(this.standardDescription.getMessage().getFullQualifiedId()), this.standardDescription.getMessage().getFullQualifiedId());
        return map;
    }

    public void writeReport(OutputStream reportOutput, IReportLogger reportLogger, IReportSerializer serializer) throws IOException, ValidationFunctionException {
        this.writeReportInternal(reportOutput, reportLogger, serializer);
    }

    public void writeReport(OutputStream reportOutput, String absolutePath, IReportLogger reportLogger, IReportSerializer serializer) throws IOException, ValidationFunctionException {
        this.writeReportInternal(reportOutput, reportLogger, serializer);
    }

    private void writeReportInternal(OutputStream reportOutput, IReportLogger reportLogger, IReportSerializer serializer) throws IOException, ValidationFunctionException {
        if (reportOutput == null) {
            throw new IllegalArgumentException("The parameter reportOutput cannot be null");
        }
        if (reportLogger == null) {
            throw new IllegalArgumentException("The parameter reportLogger of the conversion method can't be null");
        }
        if (serializer == null) {
            throw new IllegalArgumentException("The parameter serializer of the conversion method can't be null");
        }
        try {
            serializer.serialize(reportOutput, reportLogger, this.standardDescription.getNamespacePrefix(), this.standardDescription.getNameSpace(), this.modelAccessor);
        }
        catch (SerializationException e) {
            this.logger.error("[Saturne] The XML report serialization has failed", (Throwable)e);
            throw new ValidationFunctionException(e);
        }
    }

    public void convertAndSerializeToXml(InputStream textInput, OutputStream xmlOutput, IReportLogger reportLogger, String encoding, FormatType messageFormat) throws ValidationFunctionException, TooManyAnomaliesException {
        IMessageBlock rootTMBlock = this.helperConversion.convertAndSerializeToXml(textInput, xmlOutput, reportLogger, encoding, messageFormat);
        if (this.rootMessageBlock == null) {
            this.rootMessageBlock = rootTMBlock;
        }
    }

    public void serializeToCSV(IMessageBlock messageBlock, ITreeConsumer serializer) throws IOException, ValidationFunctionException {
        this.helperSerialisation.serializeToCSV(messageBlock, serializer);
    }

    public IMessageBlock convertFromCSV(InputStream textInput, IReportLogger reportLogger) throws IOException, ValidationFunctionException, TooManyAnomaliesException {
        return this.helperConversion.convertFromCSV(textInput, reportLogger);
    }

    public IMessageBlock convertFromJson(InputStream textInput, IReportLogger reportLogger) throws IOException, ValidationFunctionException, TooManyAnomaliesException {
        return this.helperConversion.convertFromJson(textInput, reportLogger);
    }

    public void serializeToCSV(IMessageBlock message, OutputStream csvOutput, String encoding) throws IOException, ValidationFunctionException {
        this.helperSerialisation.serializeToCSV(message, csvOutput, encoding);
    }

    public void serializeToJson(IMessageBlock message, OutputStream jsonOutput, String encoding) throws IOException, ValidationFunctionException {
        this.helperSerialisation.serializeToJson(message, jsonOutput, encoding);
    }

    public void serializeToKeyValue(IMessageBlock message, OutputStream output) throws IOException, ValidationFunctionException {
        this.helperSerialisation.serializeToKeyValue(message, output);
    }

    public void serializeToKeyValue(IMessageBlock message, ITreeConsumer serializer) throws IOException, ValidationFunctionException {
        this.helperSerialisation.serializeToKeyValue(message, serializer);
    }

    public void computeContexts(InputStream xmlInput, IReportLogger reportLogger) throws IOException, ValidationFunctionException {
        if (xmlInput == null) {
            throw new ValidationFunctionException("The xml input file is null.");
        }
        if (reportLogger == null) {
            throw new ValidationFunctionException("The parameter reportLogger of the conversion method can't be null");
        }
        if (this.reportContextDescriptor == null) {
            this.reportContextDescriptor = new ReportContextDescriptor(this.modelAccessor.getStandard());
        }
        ReportContextCalculator reportContextCalculator = new ReportContextCalculator(this.modelAccessor, this.reportContextDescriptor, xmlInput);
        boolean xmlNoPrefix = this.getXmlNoPrefix();
        reportContextCalculator.calculateReportContexts(reportLogger, this.xmlTag2QualifiedId, xmlNoPrefix);
    }

    public StandardAccessor getModelAccessor() {
        return this.modelAccessor;
    }

    public StandardDescription getStandardDescription() {
        return this.standardDescription;
    }

    public IRuleRegistry getSyntacticRuleRegistry() {
        return this.syntacticRuleRegistry;
    }

    public Map<String, String> getXmlTag2QualifiedId() {
        return this.xmlTag2QualifiedId;
    }

    public OriginalValueOptionValue getEmitOriginalValue() {
        return this.emitOriginalValue;
    }

    public boolean isEmitOriginalLineNumber() {
        return this.emitOriginalLineNumber;
    }

    private void validateOnePassFromTextPrivate(InputStream textInput, OutputStream xmlOutput, IReportLogger reportLogger, boolean validateSyntactic, boolean validateSemantic, FormatType messageFormat) throws TooManyAnomaliesException, ValidationFunctionException {
        this.logger.info("[Saturne] Start of the conversion and validation in one pass");
        if (textInput == null) {
            throw new IllegalArgumentException("The parameter inputStream of the conversion method can't be null");
        }
        if (reportLogger == null) {
            throw new IllegalArgumentException("The parameter reportLogger of the conversion method can't be null");
        }
        if (messageFormat == null) {
            throw new IllegalArgumentException("The parameter formatType cannot be null");
        }
        if (this.standardFile != null) {
            throw new IllegalArgumentException("It is forbidden to validate a Standard loaded from the workspace");
        }
        MessageRecuperator messageRecuperator = new MessageRecuperator();
        try {
            try {
                ValidationFunctionsHelper validationFunctionsHelper = new ValidationFunctionsHelper(this.getKbDescriptor(), this.getControlMessages(), this.options);
                ISequenceProvider reader = validationFunctionsHelper.getReader(textInput, messageFormat);
                TreeBuilder treeBuilder = new TreeBuilder(this.getModelAccessor(), reportLogger, this.getControlMessages(), reader);
                if (xmlOutput != null) {
                    XMLSerializer xmlSerializer = null;
                    xmlSerializer = new XMLSerializer(this.getStandardDescription(), xmlOutput, "UTF-8", this.getEmitOriginalValue(), this.isEmitOriginalLineNumber(), this.getXmlNoPrefix());
                    treeBuilder.addConsumer(xmlSerializer);
                }
                treeBuilder.addConsumer(messageRecuperator);
                ValidatorWithCleaner validatorWithCleaner = new ValidatorWithCleaner(this.getModelAccessor(), reportLogger, this.executorAndCleanerRunner, validateSyntactic, validateSemantic, this.unloadingAcitvated, this.getControlMessages());
                treeBuilder.addConsumer(validatorWithCleaner);
                treeBuilder.addConsumer(reportLogger);
                boolean doFiltersSecondaryAnomaliesForSyntactic = validateSyntactic && this.doFiltersSecondaryAnomalies;
                treeBuilder.convert();
                if (doFiltersSecondaryAnomaliesForSyntactic) {
                    reportLogger.filterSecondaryAnomalies();
                }
            }
            catch (ConversionSerializationException e) {
                this.logger.error("[Saturne] The serialization of the converted message has failed", (Throwable)e);
                throw new ValidationFunctionException(e);
            }
            catch (SaturneValidatorException e) {
                this.logger.error("[Saturne] The conversion of a message into a MessageBlock has failed", (Throwable)e);
                throw new ValidationFunctionException(e);
            }
        }
        finally {
            if (this.rootMessageBlock == null) {
                this.rootMessageBlock = messageRecuperator.getRootMessageBlock();
            }
        }
        this.logger.info("[Saturne] End of the conversion");
    }

    public void validateOnePassFromText(InputStream textInput, IReportLogger reportLogger, boolean validateSyntactic, boolean validateSemantic, FormatType messageFormat) throws TooManyAnomaliesException, ValidationFunctionException {
        this.validateOnePassFromTextPrivate(textInput, null, reportLogger, validateSyntactic, validateSemantic, messageFormat);
    }

    public void validateOnePassFromText(InputStream textInput, OutputStream xmlOutput, IReportLogger reportLogger, boolean validateSyntactic, boolean validateSemantic, FormatType messageFormat) throws TooManyAnomaliesException, ValidationFunctionException {
        if (xmlOutput == null) {
            throw new IllegalArgumentException("The parameter outputStream cannot be null");
        }
        this.validateOnePassFromTextPrivate(textInput, xmlOutput, reportLogger, validateSyntactic, validateSemantic, messageFormat);
    }

    public void validateOnePassFromXml(InputStream xmlInput, IReportLogger reportLogger, boolean validateSyntactic, boolean validateSemantic) throws TooManyAnomaliesException, ValidationFunctionException {
        this.logger.info("[Saturne] Start of the conversion and validation in one pass");
        if (xmlInput == null) {
            throw new IllegalArgumentException("The parameter inputStream of the conversion method can't be null");
        }
        if (reportLogger == null) {
            throw new IllegalArgumentException("The parameter reportLogger of the conversion method can't be null");
        }
        if (this.standardFile != null) {
            throw new IllegalArgumentException("It is forbidden to validate a Standard loaded from the workspace");
        }
        boolean xmlNoPrefix = this.getXmlNoPrefix();
        XMLReaderWithDecl xmlReader = new XMLReaderWithDecl(reportLogger, this.getOptions(), this.getModelAccessor(), this.getXmlTag2QualifiedId(), this.getControlMessages(), true, xmlNoPrefix);
        MessageRecuperator messageRecuperator = new MessageRecuperator();
        xmlReader.addConsumer(messageRecuperator);
        xmlReader.addConsumer(reportLogger);
        ValidatorWithCleaner validatorWithCleaner = new ValidatorWithCleaner(this.getModelAccessor(), reportLogger, this.executorAndCleanerRunner, validateSyntactic, validateSemantic, this.unloadingAcitvated, this.getControlMessages());
        boolean doFiltersSecondaryAnomaliesForSyntactic = validateSyntactic && this.doFiltersSecondaryAnomalies;
        xmlReader.addConsumer(validatorWithCleaner);
        try {
            try {
                xmlReader.read(xmlInput);
                if (doFiltersSecondaryAnomaliesForSyntactic) {
                    reportLogger.filterSecondaryAnomalies();
                }
            }
            catch (IOException e) {
                this.logger.error("[Saturne] The conversion of a message into a MessageBlock has failed", (Throwable)e);
                throw new ValidationFunctionException(e);
            }
            catch (TreeProcessingException e) {
                if (e.getCause() instanceof TooManyAnomaliesException) {
                    TooManyAnomaliesException t = (TooManyAnomaliesException)e.getCause();
                    throw t;
                }
                this.logger.error("[Saturne] The conversion of an XML message into a MessageBlock has failed", (Throwable)e);
                throw new ValidationFunctionException(e);
            }
        }
        finally {
            if (this.rootMessageBlock == null) {
                this.rootMessageBlock = messageRecuperator.getRootMessageBlock();
            }
        }
        this.logger.info("[Saturne] End of the conversion");
    }
}

